/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.Expression;
import org.exist.xquery.Pragma;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;

public class TimerPragma
extends Pragma {
    public static final QName TIMER_PRAGMA = new QName("timer", "http://exist.sourceforge.net/NS/exist", "exist");
    private static final Logger LOG = Logger.getLogger((Class)TimerPragma.class);
    private long start;

    public TimerPragma(QName qname, String contents) throws XPathException {
        super(qname, contents);
    }

    public void after(XQueryContext context, Expression expression) throws XPathException {
        long elapsed = System.currentTimeMillis() - this.start;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Elapsed: " + elapsed + "ms. for expression:\n" + ExpressionDumper.dump(expression)));
        }
    }

    public void before(XQueryContext context, Expression expression) throws XPathException {
        this.start = System.currentTimeMillis();
    }
}

