/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

public class RemoteCollectionManagementService
implements CollectionManagementServiceImpl {
    protected XmlRpcClient client;
    protected RemoteCollection parent = null;

    public RemoteCollectionManagementService(RemoteCollection parent, XmlRpcClient client) {
        this.client = client;
        this.parent = parent;
    }

    public Collection createCollection(String collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    public Collection createCollection(XmldbURI collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    public Collection createCollection(String collName, Date created) throws XMLDBException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(collName), created);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public Collection createCollection(XmldbURI collName, Date created) throws XMLDBException {
        if (this.parent != null) {
            collName = this.parent.getPathURI().resolveCollectionPath(collName);
        }
        Vector<Object> params = new Vector<Object>();
        params.addElement(collName.toString());
        if (created != null) {
            params.addElement(created);
        }
        try {
            this.client.execute("createCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
        RemoteCollection collection = new RemoteCollection(this.client, this.parent, collName);
        this.parent.addChildCollection(collection);
        return collection;
    }

    public Collection createCollection(String path, Document configuration) throws XMLDBException {
        return this.createCollection(path);
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getProperty(String property) {
        return null;
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void removeCollection(String collName) throws XMLDBException {
        try {
            this.removeCollection(XmldbURI.xmldbUriFor(collName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void removeCollection(XmldbURI collName) throws XMLDBException {
        if (this.parent != null) {
            collName = this.parent.getPathURI().resolveCollectionPath(collName);
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collName.toString());
        try {
            this.client.execute("removeCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
        this.parent.removeChildCollection(collName);
    }

    public void setCollection(Collection parent) throws XMLDBException {
        this.parent = (RemoteCollection)parent;
    }

    public void setProperty(String property, String value) {
    }

    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.move(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void move(XmldbURI collectionPath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        XmldbURI xmldbURI = destinationPath = destinationPath == null ? collectionPath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        if (newName == null) {
            newName = collectionPath.lastSegment();
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collectionPath.toString());
        params.addElement(destinationPath.toString());
        params.addElement(newName.toString());
        try {
            this.client.execute("moveCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.moveResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void moveResource(XmldbURI resourcePath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        resourcePath = this.parent.getPathURI().resolveCollectionPath(resourcePath);
        destinationPath = destinationPath == null ? resourcePath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        if (newName == null) {
            newName = resourcePath.lastSegment();
        }
        Vector<String> params = new Vector<String>();
        params.addElement(resourcePath.toString());
        params.addElement(destinationPath.toString());
        params.addElement(newName.toString());
        try {
            this.client.execute("moveResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copy(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void copy(XmldbURI collectionPath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        XmldbURI xmldbURI = destinationPath = destinationPath == null ? collectionPath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        if (newName == null) {
            newName = collectionPath.lastSegment();
        }
        Vector<String> params = new Vector<String>();
        params.addElement(collectionPath.toString());
        params.addElement(destinationPath.toString());
        params.addElement(newName.toString());
        try {
            this.client.execute("copyCollection", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copyResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void copyResource(XmldbURI resourcePath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        resourcePath = this.parent.getPathURI().resolveCollectionPath(resourcePath);
        destinationPath = destinationPath == null ? resourcePath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        if (newName == null) {
            newName = resourcePath.lastSegment();
        }
        Vector<String> params = new Vector<String>();
        params.addElement(resourcePath.toString());
        params.addElement(destinationPath.toString());
        params.addElement(newName.toString());
        try {
            this.client.execute("copyResource", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(1, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }
}

