/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabListPopup;
import org.netbeans.swing.tabcontrol.plaf.TabListPopupAction;
import org.netbeans.swing.tabcontrol.plaf.WinXPEditorTabCellRenderer;

public final class WinXPEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    protected static final int[] xpoints = new int[20];
    protected static final int[] ypoints = new int[20];
    private static final Rectangle scratch5 = new Rectangle();
    private static final String[] iconNames = new String[]{"org/netbeans/swing/tabcontrol/resources/xp-right-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-right-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-right-enabled-selected.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-left-enabled-selected.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-enabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-disabled.gif", "org/netbeans/swing/tabcontrol/resources/xp-down-enabled-selected.gif"};

    public WinXPEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinXPEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    public void install() {
        super.install();
        Color color = UIManager.getColor("nb_workplace_fill");
        if (color == null) {
            color = new Color(226, 223, 214);
        }
        this.displayer.setBackground(color);
    }

    protected AbstractButton[] createControlButtons() {
        AbstractButton[] abstractButtonArray = new JButton[]{new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getBackwardAction()), new BasicScrollingTabDisplayerUI.TimerButton(this.scroll().getForwardAction()), new BasicScrollingTabDisplayerUI.OnPressButton(new TabListPopupAction(this.displayer))};
        WinXPEditorTabDisplayerUI.configureButton(abstractButtonArray[0], 0);
        WinXPEditorTabDisplayerUI.configureButton(abstractButtonArray[2], 1);
        WinXPEditorTabDisplayerUI.configureButton(abstractButtonArray[1], 2);
        abstractButtonArray[0].setPreferredSize(new Dimension(15, 14));
        abstractButtonArray[2].setPreferredSize(new Dimension(16, 14));
        abstractButtonArray[1].setPreferredSize(new Dimension(15, 14));
        this.scroll().getBackwardAction().putValue("control", this.displayer);
        this.scroll().getForwardAction().putValue("control", this.displayer);
        return abstractButtonArray;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 24;
        Graphics2D graphics2D = TabListPopup.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 8;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    private static final Icon createIcon(int n) {
        return new ImageIcon(WinXPEditorTabDisplayerUI.loadImage(iconNames[n]));
    }

    private static final Image loadImage(String string) {
        try {
            URL uRL = WinXPEditorTabDisplayerUI.class.getClassLoader().getResource(string);
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new BufferedImage(12, 12, 2);
        }
    }

    private static void configureButton(JButton jButton, int n) {
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setContentAreaFilled(false);
        Icon icon = WinXPEditorTabDisplayerUI.createIcon(n * 3);
        Icon icon2 = WinXPEditorTabDisplayerUI.createIcon(n * 3 + 1);
        Icon icon3 = WinXPEditorTabDisplayerUI.createIcon(n * 3 + 2);
        jButton.setIcon(icon);
        jButton.setRolloverEnabled(true);
        jButton.setRolloverIcon(icon3);
        jButton.setDisabledIcon(icon2);
        jButton.setPreferredSize(new Dimension(icon.getIconWidth() + 1, icon.getIconHeight() + 1));
        jButton.setMargin(null);
        jButton.setText(null);
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setFocusable(false);
    }

    public void paintBackground(Graphics graphics) {
        graphics.setColor(this.displayer.getBackground());
        graphics.fillRect(0, 0, this.displayer.getWidth(), this.displayer.getHeight());
    }

    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        Insets insets = this.getTabAreaInsets();
        int n = this.displayer.getHeight() - 3;
        int n2 = 0;
        int n3 = this.selectionModel.getSelectedIndex();
        graphics.setColor(WinXPEditorTabCellRenderer.getSelectedTabBottomLineColor());
        graphics.drawLine(0, n + 1, this.displayer.getWidth(), n + 1);
        int n4 = this.getTabsAreaWidth();
        boolean bl = n3 != -1 && (n3 < this.scroll().getLastVisibleTab(n4) || n3 <= this.scroll().getLastVisibleTab(n4) && !this.scroll().isLastTabClipped()) && n3 >= this.scroll().getFirstVisibleTab(n4);
        graphics.setColor(UIManager.getColor("controlLtHighlight"));
        if (bl) {
            this.getTabRect(n3, scratch5);
            if (WinXPEditorTabDisplayerUI.scratch5.width != 0) {
                if (rectangle.x < WinXPEditorTabDisplayerUI.scratch5.x) {
                    graphics.drawLine(rectangle.x, n, WinXPEditorTabDisplayerUI.scratch5.x + 1, n);
                }
                if (WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width < rectangle.x + rectangle.width) {
                    n2 = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --n2;
                    }
                    graphics.drawLine(n2, n, rectangle.x + rectangle.width, n);
                }
            }
        } else {
            graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width, n);
        }
        graphics.setColor(WinXPEditorTabCellRenderer.getBorderColor());
        graphics.drawLine(0, n - 1, 0, this.displayer.getHeight());
        graphics.drawLine(this.displayer.getWidth() - 1, n - 1, this.displayer.getWidth() - 1, this.displayer.getHeight());
        int n5 = this.scroll().getLastVisibleTab(n4);
        boolean bl2 = false;
        if (n5 >= 0) {
            this.getTabRect(n5, scratch5);
            n5 = WinXPEditorTabDisplayerUI.scratch5.x + WinXPEditorTabDisplayerUI.scratch5.width;
        }
        graphics.drawLine(n5, n - 1, this.displayer.getWidth(), n - 1);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new WinXPEditorTabCellRenderer();
    }

    protected LayoutManager createLayout() {
        return new WCLayout();
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, 55);
    }

    private class WCLayout
    implements LayoutManager {
        private WCLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Insets insets = WinXPEditorTabDisplayerUI.this.getTabAreaInsets();
            Component[] componentArray = container.getComponents();
            int n = container.getWidth() - 49;
            int n2 = 0;
            for (int i = 0; i < componentArray.length; ++i) {
                n2 = insets.top;
                if (!(componentArray[i] instanceof JButton)) continue;
                int n3 = Math.min(((JButton)componentArray[i]).getIcon().getIconWidth(), container.getWidth() - n);
                componentArray[i].setBounds(n, n2, n3, Math.min(((JButton)componentArray[i]).getIcon().getIconHeight(), container.getHeight()));
                n += ((JButton)componentArray[i]).getIcon().getIconWidth();
                if (i != 1) continue;
                n += 3;
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return WinXPEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return WinXPEditorTabDisplayerUI.this.getPreferredSize((JComponent)container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

