/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.BaseTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class WinClassicViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final boolean isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    private static final int BUMP_X_PAD = isGenericUI ? 0 : 3;
    private static final int BUMP_WIDTH = isGenericUI ? 0 : 3;
    private static final int TXT_X_PAD = isGenericUI ? 3 : BUMP_X_PAD + BUMP_WIDTH + 5;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private WinClassicViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        this.prefSize = new Dimension(Integer.MAX_VALUE, 19);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WinClassicViewTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        int n = fontMetrics == null ? 19 : fontMetrics.getAscent() + 2 * fontMetrics.getDescent() + 2;
        Insets insets = jComponent.getInsets();
        this.prefSize.height = n + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (isGenericUI && ColorUtil.gtkShouldAntialias()) {
            ColorUtil.setupAntialiasing(graphics);
        }
        this.paintOverallBorder(graphics, jComponent);
        Color color = jComponent.getBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        super.paint(graphics, jComponent);
    }

    protected void paintOverallBorder(Graphics graphics, JComponent jComponent) {
        if (isGenericUI) {
            return;
        }
        Rectangle rectangle = jComponent.getBounds();
        graphics.setColor(UIManager.getColor("InternalFrame.borderDarkShadow"));
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    protected Font getTxtFont() {
        Font font;
        if (isGenericUI && (font = UIManager.getFont("controlFont")) != null) {
            return font;
        }
        return super.getTxtFont();
    }

    protected void paintTabContent(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Object object;
        --n5;
        n3 -= 2;
        FontMetrics fontMetrics = this.getTxtFontMetrics();
        String string2 = null;
        graphics.setFont(this.getTxtFont());
        if (this.isSelected(n)) {
            if (closeIcon == null) {
                closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
            }
            object = this.findIconPath(n);
            Icon icon = closeIcon.obtainIcon((String)object);
            int n6 = icon.getIconWidth();
            AbstractViewTabDisplayerUI.PinButton pinButton = this.getPinButton(n);
            int n7 = pinButton != null ? pinButton.getWidth() + 1 : 0;
            int n8 = n6 + 2 + n7 + 4;
            string2 = WinClassicViewTabDisplayerUI.stripTextToFit(string, n4 - n8, fontMetrics);
            int n9 = BaseTabLayoutModel.textWidth(string2, this.getTxtFont());
            this.getCloseIconRect(this.tempRect, n);
            if (pinButton != null) {
                pinButton.setLocation(this.tempRect.x - n7, this.tempRect.y);
            }
            icon.paintIcon(this.getDisplayer(), graphics, this.tempRect.x, this.tempRect.y);
        } else {
            string2 = WinClassicViewTabDisplayerUI.stripTextToFit(string, n4 - 2 * TXT_X_PAD, fontMetrics);
        }
        this.drawBump(graphics, n, n2 + 4, n3 + 6, BUMP_WIDTH, n5 - 8);
        object = UIManager.getColor("TabbedPane.foreground");
        HtmlRenderer.renderString(string2, graphics, n2 + TXT_X_PAD, n3 + fontMetrics.getAscent() + 3, n4, n5, this.getTxtFont(), (Color)object, 0, true);
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = n == this.getDataModel().size() - 1;
        graphics.translate(n2, n3);
        graphics.setColor(UIManager.getColor("InternalFrame.borderShadow"));
        graphics.drawLine(0, --n5 - 1, n4 - 2, n5 - 1);
        if (bl2) {
            graphics.drawLine(n4 - 1, n5 - 1, n4 - 1, 0);
        } else {
            graphics.drawLine(n4 - 2, n5 - 2, n4 - 2, 0);
        }
        graphics.setColor(bl ? UIManager.getColor("InternalFrame.borderHighlight") : UIManager.getColor("InternalFrame.borderLight"));
        graphics.drawLine(0, 0, 0, n5 - 1);
        graphics.drawLine(1, 0, n4 - 2, 0);
        if (!bl2) {
            graphics.setColor(UIManager.getColor("InternalFrame.borderDarkShadow"));
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
        }
        graphics.translate(-n2, -n3);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        ((Graphics2D)graphics).setPaint(this.getBackgroundPaint(graphics, n, n2, n3, n4, --n5));
        if (this.isFocused(n)) {
            graphics.fillRect(n2, n3, n4, n5);
        } else {
            graphics.fillRect(n2 + 1, n3 + 1, n4 - 2, n5 - 2);
        }
    }

    private Paint getBackgroundPaint(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        boolean bl = this.isSelected(n);
        boolean bl2 = this.isFocused(n);
        Paint paint = null;
        paint = bl2 ? ColorUtil.getGradientPaint(n2, n3, WinClassicViewTabDisplayerUI.getSelGradientColor(), n2 + n4, n3, UIManager.getColor("TabbedPane.background")) : (bl ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
        return paint;
    }

    private String findIconPath(int n) {
        if (this.controller.isClosePressed() == n) {
            return "org/netbeans/swing/tabcontrol/resources/win_bigclose-pressed.gif";
        }
        if (this.controller.isMouseInCloseButton() == n) {
            return "org/netbeans/swing/tabcontrol/resources/win_bigclose-rollover.gif";
        }
        return "org/netbeans/swing/tabcontrol/resources/win_bigclose-normal.gif";
    }

    private void drawBump(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Color color;
        Color color2;
        Color color3;
        if (isGenericUI) {
            return;
        }
        if (this.isFocused(n)) {
            color3 = new Color(210, 220, 243);
            color2 = color3.brighter();
            color = color3.darker();
        } else if (this.isSelected(n)) {
            color2 = UIManager.getColor("InternalFrame.borderHighlight");
            color3 = UIManager.getColor("InternalFrame.borderLight");
            color = UIManager.getColor("InternalFrame.borderShadow");
        } else {
            color2 = UIManager.getColor("InternalFrame.borderLight");
            color3 = UIManager.getColor("tab_unsel_fill");
            color = UIManager.getColor("InternalFrame.borderShadow");
        }
        int n6 = 0;
        while (n6 < n4 / 3) {
            graphics.setColor(color2);
            graphics.drawLine(n2, n3, n2, n3 + n5 - 1);
            graphics.drawLine(n2, n3, n2 + 1, n3);
            graphics.setColor(color3);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + n5 - 2);
            graphics.setColor(color);
            graphics.drawLine(n2 + 2, n3, n2 + 2, n3 + n5 - 1);
            graphics.drawLine(n2, n3 + n5 - 1, n2 + 1, n3 + n5 - 1);
            ++n6;
            n2 += 3;
        }
    }

    private Rectangle getCloseIconRect(Rectangle rectangle, int n) {
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n2 = tabLayoutModel.getX(n);
        int n3 = tabLayoutModel.getY(n);
        int n4 = tabLayoutModel.getW(n);
        int n5 = tabLayoutModel.getH(n);
        String string = this.findIconPath(n);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(string);
        int n6 = icon.getIconWidth();
        int n7 = icon.getIconHeight();
        rectangle.x = n2 + n4 - n6 - 2;
        rectangle.y = this.getCenteredIconY(icon, n) - 1;
        rectangle.width = n6;
        rectangle.height = n7;
        return rectangle;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> hashMap = new HashMap<Object, String>(6);
        hashMap.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-east.gif");
        hashMap.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-west.gif");
        hashMap.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-south.gif");
        hashMap.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-normal-center.gif");
        HashMap<Object, String> hashMap2 = new HashMap<Object, String>(6);
        hashMap2.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-east.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-west.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-south.gif");
        hashMap2.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-pressed-center.gif");
        HashMap<Object, String> hashMap3 = new HashMap<Object, String>(6);
        hashMap3.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-east.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-west.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-south.gif");
        hashMap3.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/win-pin-rollover-center.gif");
        return new AbstractViewTabDisplayerUI.PinButton(hashMap, hashMap2, hashMap3);
    }

    private static final Color getSelGradientColor() {
        return UIManager.getColor("winclassic_tab_sel_gradient");
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            int n = WinClassicViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n < 0) {
                return -1;
            }
            return WinClassicViewTabDisplayerUI.this.getCloseIconRect(WinClassicViewTabDisplayerUI.this.tempRect, n).contains(point) ? n : -1;
        }
    }
}

