/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.function.StringFunction;

public class LangFunction
implements Function {
    public Object call(Context context, List list) throws FunctionCallException {
        if (list.size() != 1) {
            throw new FunctionCallException("lang() requires exactly one argument.");
        }
        Object e = list.get(0);
        try {
            return LangFunction.evaluate(context.getNodeSet(), e, context.getNavigator());
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new FunctionCallException("Can't evaluate lang()", unsupportedAxisException);
        }
    }

    private static Boolean evaluate(List list, Object object, Navigator navigator) throws UnsupportedAxisException {
        return LangFunction.evaluate(list.get(0), StringFunction.evaluate(object, navigator), navigator) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static boolean evaluate(Object object, String string, Navigator navigator) throws UnsupportedAxisException {
        Object object2 = object;
        if (!navigator.isElement(object2)) {
            object2 = navigator.getParentNode(object);
        }
        while (object2 != null && navigator.isElement(object2)) {
            Iterator iterator = navigator.getAttributeAxisIterator(object2);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!"lang".equals(navigator.getAttributeName(e)) || !"http://www.w3.org/XML/1998/namespace".equals(navigator.getAttributeNamespaceUri(e))) continue;
                return LangFunction.isSublang(navigator.getAttributeStringValue(e), string);
            }
            object2 = navigator.getParentNode(object2);
        }
        return false;
    }

    private static boolean isSublang(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = string2.length();
        return string.length() > n && string.charAt(n) == '-' && string.substring(0, n).equalsIgnoreCase(string2);
    }
}

