/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.ram.RamFileSystem;

public class RamFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static RamFileSystemConfigBuilder singleton = new RamFileSystemConfigBuilder();

    private RamFileSystemConfigBuilder() {
    }

    public static RamFileSystemConfigBuilder getInstance() {
        return singleton;
    }

    protected Class getConfigClass() {
        return RamFileSystem.class;
    }

    public int getMaxSize(FileSystemOptions fileSystemOptions) {
        Integer n = (Integer)this.getParam(fileSystemOptions, "maxsize");
        if (n != null) {
            return n;
        }
        return Integer.MAX_VALUE;
    }

    public void setMaxSize(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "maxsize", new Integer(n));
    }
}

