/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.RandomAccessMode;

public class LocalFile
extends AbstractFileObject
implements FileObject {
    private final String rootFile;
    private File file;

    protected LocalFile(LocalFileSystem localFileSystem, String string, FileName fileName) throws FileSystemException {
        super(fileName, localFileSystem);
        this.rootFile = string;
    }

    protected File getLocalFile() {
        return this.file;
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            String string = this.rootFile + this.getName().getPathDecoded();
            this.file = new File(string);
        }
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists() && this.file.length() < 1L) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return UriParser.encode(this.file.list());
    }

    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", this.file);
        }
    }

    protected void doRename(FileObject fileObject) throws Exception {
        LocalFile localFile = (LocalFile)FileObjectUtils.getAbstractFileObject(fileObject);
        if (!this.file.renameTo(localFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", new String[]{this.file.toString(), fileObject.toString()});
        }
    }

    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", this.file);
        }
    }

    protected boolean doIsWriteable() throws FileSystemException {
        return this.file.canWrite();
    }

    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    protected boolean doIsReadable() throws FileSystemException {
        return this.file.canRead();
    }

    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.file.lastModified();
    }

    protected void doSetLastModifiedTime(long l) throws FileSystemException {
        this.file.setLastModified(l);
    }

    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return new FileOutputStream(this.file.getPath(), bl);
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, randomAccessMode);
    }

    protected boolean doIsSameFile(FileObject fileObject) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf(fileObject, LocalFile.class)) {
            return false;
        }
        LocalFile localFile = (LocalFile)FileObjectUtils.getAbstractFileObject(fileObject);
        if (!this.exists() || !localFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(localFile.file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
    }
}

