/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.ftp.FtpClient;
import org.apache.commons.vfs.provider.ftp.FtpClientFactory;
import org.apache.commons.vfs.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs.util.UserAuthenticatorUtils;

class FTPClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPClient ftpClient = null;

    FTPClientWrapper(GenericFileName genericFileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = genericFileName;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient createClient() throws FileSystemException {
        FTPClient fTPClient;
        GenericFileName genericFileName = this.getRoot();
        UserAuthenticationData userAuthenticationData = null;
        try {
            userAuthenticationData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpFileProvider.AUTHENTICATOR_TYPES);
            fTPClient = FtpClientFactory.createConnection(genericFileName.getHostName(), genericFileName.getPort(), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(genericFileName.getUserName())), UserAuthenticatorUtils.getData(userAuthenticationData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(genericFileName.getPassword())), genericFileName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(userAuthenticationData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(userAuthenticationData);
        return fTPClient;
    }

    private FTPClient getFtpClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.getFtpClient().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String string) throws IOException {
        try {
            return this.getFtpClient().listFiles(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().listFiles(string);
        }
    }

    public boolean removeDirectory(String string) throws IOException {
        try {
            return this.getFtpClient().removeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().removeDirectory(string);
        }
    }

    public boolean deleteFile(String string) throws IOException {
        try {
            return this.getFtpClient().deleteFile(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().deleteFile(string);
        }
    }

    public boolean rename(String string, String string2) throws IOException {
        try {
            return this.getFtpClient().rename(string, string2);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().rename(string, string2);
        }
    }

    public boolean makeDirectory(String string) throws IOException {
        try {
            return this.getFtpClient().makeDirectory(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().makeDirectory(string);
        }
    }

    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpClient().completePendingCommand();
        }
        return true;
    }

    public InputStream retrieveFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().retrieveFileStream(string);
        }
    }

    public InputStream retrieveFileStream(String string, long l) throws IOException {
        try {
            FTPClient fTPClient = this.getFtpClient();
            fTPClient.setRestartOffset(l);
            return fTPClient.retrieveFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            FTPClient fTPClient = this.getFtpClient();
            fTPClient.setRestartOffset(l);
            return fTPClient.retrieveFileStream(string);
        }
    }

    public OutputStream appendFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().appendFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().appendFileStream(string);
        }
    }

    public OutputStream storeFileStream(String string) throws IOException {
        try {
            return this.getFtpClient().storeFileStream(string);
        }
        catch (IOException iOException) {
            this.disconnect();
            return this.getFtpClient().storeFileStream(string);
        }
    }

    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException iOException) {
            this.disconnect();
            return true;
        }
    }

    public String getReplyString() throws IOException {
        return this.getFtpClient().getReplyString();
    }
}

