/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    public FileObject findFile(FileObject fileObject, String string, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName fileName;
        try {
            fileName = this.parseUri(fileObject != null ? fileObject.getName() : null, string);
        }
        catch (FileSystemException fileSystemException) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", string, (Throwable)fileSystemException);
        }
        return this.findFile(fileName, fileSystemOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject findFile(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileSystem fileSystem;
        FileName fileName2 = this.getContext().getFileSystemManager().resolveName(fileName, "/");
        AbstractOriginatingFileProvider abstractOriginatingFileProvider = this;
        synchronized (abstractOriginatingFileProvider) {
            fileSystem = this.findFileSystem(fileName2, fileSystemOptions);
            if (fileSystem == null) {
                fileSystem = this.doCreateFileSystem(fileName2, fileSystemOptions);
                this.addFileSystem(fileName2, fileSystem);
            }
        }
        return fileSystem.resolveFile(fileName);
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

