/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.FontSizeHints;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ShadowPopup;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;

public final class Options {
    private static final Map LAF_REPLACEMENTS = new HashMap();
    private static final Boolean TAB_ICONS_ENABLED_SYSTEM_VALUE;
    private static final Boolean POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
    private static final Dimension DEFAULT_ICON_SIZE;

    public static boolean getUseSystemFonts() {
        return UIManager.get("Application.useSystemFontSettings").equals(Boolean.TRUE);
    }

    public static void setUseSystemFonts(boolean bl) {
        UIManager.put("Application.useSystemFontSettings", bl);
    }

    public static Dimension getDefaultIconSize() {
        Dimension dimension = UIManager.getDimension("jgoodies.defaultIconSize");
        return dimension == null ? DEFAULT_ICON_SIZE : dimension;
    }

    public static void setDefaultIconSize(Dimension dimension) {
        UIManager.put("jgoodies.defaultIconSize", dimension);
    }

    public static FontSizeHints getGlobalFontSizeHints() {
        Object object = UIManager.get("jgoodies.fontSizeHints");
        if (object != null) {
            return (FontSizeHints)object;
        }
        String string = LookUtils.getSystemProperty("jgoodies.fontSizeHints", "");
        try {
            return FontSizeHints.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return FontSizeHints.DEFAULT;
        }
    }

    public static void setGlobalFontSizeHints(FontSizeHints fontSizeHints) {
        UIManager.put("jgoodies.fontSizeHints", fontSizeHints);
    }

    public static boolean getUseNarrowButtons() {
        return UIManager.getBoolean("jgoodies.useNarrowButtons");
    }

    public static void setUseNarrowButtons(boolean bl) {
        UIManager.put("jgoodies.useNarrowButtons", bl);
    }

    public static boolean isTabIconsEnabled() {
        return TAB_ICONS_ENABLED_SYSTEM_VALUE == null ? !Boolean.FALSE.equals(UIManager.get("jgoodies.tabIconsEnabled")) : TAB_ICONS_ENABLED_SYSTEM_VALUE;
    }

    public static void setTabIconsEnabled(boolean bl) {
        UIManager.put("jgoodies.tabIconsEnabled", bl);
    }

    public static boolean isPopupDropShadowActive() {
        boolean bl = LookUtils.IS_OS_MAC;
        return !bl && ShadowPopup.canSnapshot() && Options.isPopupDropShadowEnabled();
    }

    public static boolean isPopupDropShadowEnabled() {
        if (POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE != null) {
            return POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
        }
        Object object = UIManager.get("jgoodies.popupDropShadowEnabled");
        return object == null ? Options.isPopupDropShadowEnabledDefault() : Boolean.TRUE.equals(object);
    }

    public static void setPopupDropShadowEnabled(boolean bl) {
        UIManager.put("jgoodies.popupDropShadowEnabled", bl);
    }

    private static boolean isPopupDropShadowEnabledDefault() {
        return LookUtils.IS_OS_WINDOWS_MODERN;
    }

    public static void putLookAndFeelReplacement(String string, String string2) {
        LAF_REPLACEMENTS.put(string, string2);
    }

    public static void removeLookAndFeelReplacement(String string) {
        LAF_REPLACEMENTS.remove(string);
    }

    public static void initializeDefaultReplacements() {
        Options.putLookAndFeelReplacement("javax.swing.plaf.metal.MetalLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        Options.putLookAndFeelReplacement("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel");
    }

    public static String getReplacementClassNameFor(String string) {
        String string2 = (String)LAF_REPLACEMENTS.get(string);
        return string2 == null ? string : string2;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    }

    public static String getSystemLookAndFeelClassName() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "com.jgoodies.looks.windows.WindowsLookAndFeel";
        }
        if (string.startsWith("Mac")) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return Options.getCrossPlatformLookAndFeelClassName();
    }

    static {
        Options.initializeDefaultReplacements();
        TAB_ICONS_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("jgoodies.tabIconsEnabled", "Icons in tabbed panes");
        POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty("jgoodies.popupDropShadowEnabled", "Popup drop shadows");
        DEFAULT_ICON_SIZE = new Dimension(20, 20);
    }
}

