/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.error;

import com.japisoft.xmlpad.Debug;
import com.japisoft.xmlpad.error.ErrorListener;
import java.util.ArrayList;

public class ErrorManager
implements ErrorListener {
    private ArrayList errors = null;
    boolean lastCaseInError = false;
    boolean lastCaseOnTheFly = false;

    public void addErrorListener(ErrorListener errorListener) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        if (errorListener != null && !this.errors.contains(errorListener)) {
            this.errors.add(errorListener);
        }
    }

    public void removeErrorListener(ErrorListener errorListener) {
        if (this.errors != null) {
            this.errors.remove(errorListener);
        }
    }

    public void initErrorProcessing() {
        this.flushLastError();
        Debug.debug("** Init error processing ");
        if (this.errors != null) {
            for (int i = 0; i < this.errors.size(); ++i) {
                ((ErrorListener)this.errors.get(i)).initErrorProcessing();
            }
        }
    }

    public void stopErrorProcessing() {
        Debug.debug("** Stop error processing ");
        if (this.errors != null) {
            for (int i = 0; i < this.errors.size(); ++i) {
                ((ErrorListener)this.errors.get(i)).stopErrorProcessing();
            }
        }
    }

    public void notifyError(String string) {
        this.notifyError(string, 0);
    }

    public void notifyError(String string, int n) {
        this.notifyError(null, true, null, n, 0, 0, string, true);
    }

    private String resolverSourceLocationSpace(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("%20", " ");
        return string;
    }

    public void notifyError(Object object, boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        Debug.debug("** XML Error : " + string2 + " local:" + bl + " source:" + string + " line:" + n + " col:" + n2 + " offset:" + n3 + " onFly:" + bl2);
        string = this.resolverSourceLocationSpace(string);
        this.lastCaseInError = true;
        this.lastCaseOnTheFly = bl2;
        if (this.errors != null) {
            for (int i = 0; i < this.errors.size(); ++i) {
                ((ErrorListener)this.errors.get(i)).notifyError(object, bl, string, n, n2, n3, string2, bl2);
            }
        }
    }

    public void notifyUniqueError(boolean bl, String string, int n, int n2, int n3, String string2, boolean bl2) {
        this.notifyError(null, bl, string, n, n2, n3, string2, bl2);
        this.stopErrorProcessing();
    }

    public void notifyNoError(boolean bl) {
        if (this.errors != null) {
            for (int i = 0; i < this.errors.size(); ++i) {
                ((ErrorListener)this.errors.get(i)).notifyNoError(bl);
            }
        }
        this.lastCaseInError = false;
    }

    public void flushLastError() {
        this.lastCaseInError = false;
        this.lastCaseOnTheFly = false;
    }

    public boolean hasLastError() {
        return this.lastCaseInError;
    }

    public boolean hasLastErrorOnTheFly() {
        return this.lastCaseOnTheFly;
    }

    public void dispose() {
        this.errors = null;
    }
}

