/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer.data;

import com.japisoft.framework.ui.text.FileTextField;
import com.japisoft.framework.xml.grammar.GrammarElement;
import com.japisoft.framework.xml.grammar.xsd.XSDGrammar;
import com.japisoft.xmlform.UIToolkit;
import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.XMLFormComponentFactory;
import com.japisoft.xmlform.designer.data.DataPanelListener;
import com.japisoft.xmlform.designer.data.DataTreeRenderer;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.designer.data.GrammarTreeModel;
import com.japisoft.xmlform.designer.data.TreeDragDrop;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Document;

public class DataPanel
extends JPanel
implements MouseListener,
ItemListener,
ComponentContext,
TreeSelectionListener {
    private DataPanelListener listener = null;
    private HashMap<String, GrammarTreeModel> cacheModel = null;
    private XMLFormComponentFactory factory = null;
    private AbstractXMLFormComponent currentComponent = null;
    private XSDGrammar grammar = null;
    private JComboBox cbElementRoot;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane spStructure;
    private JSeparator jSeparator1;
    private JTree treeStructure;
    private FileTextField txtSchemaLocation;

    public DataPanel(DataPanelListener dataPanelListener) {
        this.listener = dataPanelListener;
        this.initComponents();
        this.treeStructure.setModel(null);
        this.txtSchemaLocation.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataPanel.this.loadSchema(DataPanel.this.txtSchemaLocation.getText());
            }
        });
        this.treeStructure.setCellRenderer(new DataTreeRenderer());
        new TreeDragDrop(this.treeStructure);
    }

    public void addNotify() {
        super.addNotify();
        this.cbElementRoot.addItemListener(this);
        this.treeStructure.addTreeSelectionListener(this);
        this.treeStructure.addMouseListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.cbElementRoot.removeItemListener(this);
        this.treeStructure.removeTreeSelectionListener(this);
        this.treeStructure.removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            // empty if block
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        GrammarNodeTreeNode grammarNodeTreeNode = (GrammarNodeTreeNode)this.treeStructure.getLastSelectedPathComponent();
        if (grammarNodeTreeNode != null && grammarNodeTreeNode.getUserObject() != null) {
            this.setCurrentComponent((AbstractXMLFormComponent)grammarNodeTreeNode.getUserObject(), false);
            this.listener.scrollTo((AbstractXMLFormComponent)grammarNodeTreeNode.getUserObject());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.selectRoot((String)this.cbElementRoot.getSelectedItem());
    }

    private void selectRoot(String string) {
        if (this.listener != null) {
            this.listener.newRoot(string);
        }
        if (this.grammar != null) {
            GrammarTreeModel grammarTreeModel;
            if (this.cacheModel == null) {
                this.cacheModel = new HashMap();
            }
            if ((grammarTreeModel = this.cacheModel.get(string)) == null) {
                List<GrammarElement> list = this.grammar.getGlobalElements();
                for (GrammarElement grammarElement : list) {
                    if (!string.equals(grammarElement.getName())) continue;
                    grammarTreeModel = new GrammarTreeModel(grammarElement);
                    this.treeStructure.setModel(grammarTreeModel);
                    break;
                }
            }
            if (grammarTreeModel != null) {
                this.cacheModel.put(string, grammarTreeModel);
                this.treeStructure.setModel(grammarTreeModel);
            }
        }
    }

    public String getSchemaLocation() {
        return this.txtSchemaLocation.getText();
    }

    public String getRoot() {
        return (String)this.cbElementRoot.getSelectedItem();
    }

    public GrammarNodeTreeNode getGrammarNodeTreeNodeRoot() {
        if (this.treeStructure.getModel() == null) {
            return null;
        }
        return (GrammarNodeTreeNode)this.treeStructure.getModel().getRoot();
    }

    public GrammarNodeTreeNode getCurrentTreeNode() {
        if (this.treeStructure.getSelectionPath() != null) {
            return (GrammarNodeTreeNode)this.treeStructure.getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    public Document getDocument() {
        return null;
    }

    public XMLFormComponentFactory getComponentFactory() {
        if (this.factory == null) {
            this.factory = new XMLFormComponentFactory(true, this);
        }
        return this.factory;
    }

    public void setCurrentComponent(AbstractXMLFormComponent abstractXMLFormComponent) {
        this.setCurrentComponent(abstractXMLFormComponent, true);
    }

    public void setCurrentComponent(AbstractXMLFormComponent abstractXMLFormComponent, boolean bl) {
        if (this.currentComponent != null) {
            this.currentComponent.setSelectedComponent(false);
        }
        this.currentComponent = abstractXMLFormComponent;
        this.currentComponent.setSelectedComponent(true);
        this.listener.setCurrentComponent(abstractXMLFormComponent);
        if (bl && abstractXMLFormComponent.getGrammarNode() != null) {
            this.selectNode(abstractXMLFormComponent.getGrammarNode());
        }
    }

    public void action(int n, Object object) {
        switch (n) {
            case 1: {
                if (this.currentComponent == null || this.currentComponent.getXMLFormComponentParent() == null || !UIToolkit.confirm("Do you want to delete this component ?")) break;
                AbstractXMLFormComponent abstractXMLFormComponent = this.currentComponent;
                this.setCurrentComponent(this.currentComponent.getXMLFormComponentParent());
                this.currentComponent.removeXMLFormComponent(abstractXMLFormComponent);
                break;
            }
            case 0: {
                this.setCurrentComponent((AbstractXMLFormComponent)object);
                break;
            }
            case 2: {
                UIToolkit.warn("" + object);
            }
        }
    }

    public void resetSchema(String string) {
        if (string == null) {
            this.grammar = null;
            this.cbElementRoot.removeAllItems();
            this.treeStructure.setModel(null);
            this.txtSchemaLocation.setText(null);
        } else {
            this.txtSchemaLocation.setText(string);
        }
    }

    public void resetRoot(String string) {
        this.cbElementRoot.setSelectedItem(string);
    }

    public void selectNode(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (treeNode != null) {
            arrayList.add(0, treeNode);
            treeNode = treeNode.getParent();
        }
        this.treeStructure.removeTreeSelectionListener(this);
        TreePath treePath = new TreePath(arrayList.toArray());
        this.treeStructure.setSelectionPath(treePath);
        this.treeStructure.scrollPathToVisible(treePath);
        this.treeStructure.addTreeSelectionListener(this);
    }

    private void loadSchema(String string) {
        if (string == null) {
            return;
        }
        try {
            this.grammar = new XSDGrammar(string);
            List<GrammarElement> list = this.grammar.getGlobalElements();
            DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
            String string2 = null;
            for (GrammarElement grammarElement : list) {
                if (string2 == null) {
                    string2 = grammarElement.getName();
                }
                defaultComboBoxModel.addElement(grammarElement.getName());
            }
            this.cbElementRoot.setModel(defaultComboBoxModel);
            if (string2 != null) {
                this.selectRoot(string2);
            }
        }
        catch (Exception exception) {
            UIToolkit.dispatchError(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtSchemaLocation = new FileTextField(null, "xsd");
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cbElementRoot = new JComboBox();
        this.jLabel3 = new JLabel();
        this.spStructure = new JScrollPane();
        this.treeStructure = new JTree();
        this.jLabel1.setText("Schema Location");
        this.jLabel2.setText("Element Root");
        this.jLabel3.setText("Document Structure");
        this.spStructure.setViewportView(this.treeStructure);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.spStructure, -1, 301, Short.MAX_VALUE).add(1, (Component)this.txtSchemaLocation, -1, 301, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add(1, (Component)this.jSeparator1, -1, 301, Short.MAX_VALUE).add(1, (Component)this.jLabel2).add(1, (Component)this.cbElementRoot, 0, 301, Short.MAX_VALUE).add(1, (Component)this.jLabel3)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.txtSchemaLocation, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.cbElementRoot, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.spStructure, -1, 256, Short.MAX_VALUE).addContainerGap()));
    }
}

