/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component;

import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.container.GridComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSerializer {
    public static Element serialize(Document document, Element element, AbstractXMLFormComponent abstractXMLFormComponent) {
        Serializable serializable;
        HashMap<String, PropertyChangeEvent> hashMap;
        abstractXMLFormComponent.resolveNextSibling();
        Element element2 = document.createElementNS(null, "field");
        element2.setAttribute("class", abstractXMLFormComponent.getClass().getName());
        Element element3 = document.createElementNS(null, "properties");
        element2.appendChild(element3);
        if (element != null) {
            element.appendChild(element2);
        }
        if ((hashMap = abstractXMLFormComponent.getModifiedProperties()) != null) {
            for (String object : hashMap.keySet()) {
                serializable = hashMap.get(object);
                Element element4 = XMLSerializer.serialize(document, (PropertyChangeEvent)serializable);
                if (element4 == null) continue;
                element3.appendChild(element4);
            }
        }
        for (int i = 0; i < abstractXMLFormComponent.getComponentCount(); ++i) {
            Component component = abstractXMLFormComponent.getComponent(i);
            if (component instanceof GridComponent) {
                serializable = (GridComponent)component;
                for (int j = 0; j < ((Container)serializable).getComponentCount(); ++j) {
                    Component component2 = ((Container)serializable).getComponent(j);
                    if (!(component2 instanceof AbstractXMLFormComponent)) continue;
                    element2.appendChild(XMLSerializer.serialize(document, element2, (AbstractXMLFormComponent)component2));
                }
            }
            if (!(component instanceof AbstractXMLFormComponent)) continue;
            element2.appendChild(XMLSerializer.serialize(document, element2, (AbstractXMLFormComponent)component));
        }
        return element2;
    }

    private static Element serialize(Document document, PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (object == null) {
            return null;
        }
        if (object instanceof Border) {
            return null;
        }
        Element element = document.createElementNS(null, "property");
        element.setAttribute("name", propertyChangeEvent.getPropertyName());
        element.setAttribute("class", object.getClass().getName());
        element.setAttribute("value", XMLSerializer.valueToString(object));
        return element;
    }

    public static String valueToString(Object object) {
        if (object instanceof String) {
            return object.toString();
        }
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (object instanceof Font) {
            Font font = (Font)object;
            return font.getFamily() + "," + font.getStyle() + "," + font.getSize();
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : stringArray) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("~~");
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        if (object instanceof HashMap) {
            StringBuffer stringBuffer = new StringBuffer();
            HashMap hashMap = (HashMap)object;
            for (String string : hashMap.keySet()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("~~");
                }
                stringBuffer.append(string);
                stringBuffer.append("~~");
                stringBuffer.append((String)hashMap.get(string));
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }
}

