/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.component;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.internationalization.Traductor;
import com.japisoft.framework.xml.XPathToolkit;
import com.japisoft.framework.xml.grammar.GrammarNode;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.CustomFocusManager;
import com.japisoft.xmlform.component.DynamicLayout;
import com.japisoft.xmlform.component.EditingContext;
import com.japisoft.xmlform.component.StaticXMLFormComponent;
import com.japisoft.xmlform.component.XMLDeserizalizer;
import com.japisoft.xmlform.component.XMLFormComponent;
import com.japisoft.xmlform.component.XMLFormComponentFactory;
import com.japisoft.xmlform.component.XMLSerializer;
import com.japisoft.xmlform.component.container.GridComponent;
import com.japisoft.xmlform.component.container.XMLFormContainer;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.designer.properties.PropertyDescriptor;
import com.japisoft.xmlform.designer.properties.PropertyDescriptorImpl;
import com.japisoft.xmlform.designer.properties.descriptors.HeightPropertyDescriptor;
import com.japisoft.xmlform.designer.properties.descriptors.WidthPropertyDescriptor;
import com.japisoft.xmlform.designer.properties.descriptors.XPropertyDescriptor;
import com.japisoft.xmlform.designer.properties.descriptors.YPropertyDescriptor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLFormComponent
extends JComponent
implements MouseMotionListener,
MouseListener,
HierarchyListener,
PropertyChangeListener,
ActionListener,
XMLFormComponent {
    protected boolean designMode = false;
    protected ComponentContext context = null;
    private boolean topComponent = false;
    protected GrammarNodeTreeNode node = null;
    private Element fieldDescription = null;
    private boolean referenceComponent = false;
    private int maxOccurs = 1;
    private int minOccurs = 1;
    private int occurence = 1;
    private String id = null;
    private boolean required = false;
    private String siblingId = null;
    private Border savedBorder = null;
    private AbstractXMLFormComponent previousSiblingComponent = null;
    protected Node dom = null;
    private boolean listening = false;
    private boolean listeningHierarchy = false;
    private JButton addRemoveButton = null;
    private HashMap<String, PropertyChangeEvent> mapProperties = null;
    private boolean selected = false;
    protected String xpath = null;
    protected JLabel label = null;
    private int resizeMode = 0;
    private MouseEvent firstResizeMouseEvent = null;
    private int initHeight = 0;
    private int initWidth = 0;

    public AbstractXMLFormComponent(boolean bl, ComponentContext componentContext) {
        this.setContext(componentContext);
        this.designMode = bl;
        this.checkListening();
        this.setLayout(new BorderLayout());
        if (bl) {
            this.setBorder(new LineBorder(Color.BLACK));
        }
    }

    public void setReferenceComponent(boolean bl) {
        this.referenceComponent = bl;
    }

    public void setContext(ComponentContext componentContext) {
        this.context = componentContext;
    }

    public void setGrammarNode(GrammarNodeTreeNode grammarNodeTreeNode) {
        this.node = grammarNodeTreeNode;
        grammarNodeTreeNode.setUserObject(this);
        this.setXpath(grammarNodeTreeNode.toXPath());
        GrammarNode grammarNode = grammarNodeTreeNode.getSource();
        if (grammarNode != null) {
            this.setMaxOccurs(grammarNode.getMaxOccurs());
            this.setMinOccurs(grammarNode.getMinOccurs());
        }
        this.setId(grammarNodeTreeNode.getId());
    }

    public GrammarNodeTreeNode getGrammarNode() {
        return this.node;
    }

    public void setFieldDescription(Element element) {
        this.fieldDescription = element;
    }

    public AbstractXMLFormComponent getXMLFormComponentParent() {
        GridComponent gridComponent;
        if (this.getParent() instanceof AbstractXMLFormComponent) {
            return (AbstractXMLFormComponent)this.getParent();
        }
        if (this.getParent() instanceof GridComponent && (gridComponent = (GridComponent)this.getParent()).getParent() instanceof AbstractXMLFormComponent) {
            return (AbstractXMLFormComponent)gridComponent.getParent();
        }
        return null;
    }

    public Container getComponentContainer() {
        return this;
    }

    public void setMaxOccurs(int n) {
        this.firePropertyChange("maxOccurs", this.maxOccurs, n);
        this.maxOccurs = n;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int n) {
        this.firePropertyChange("minOccurs", this.minOccurs, n);
        this.minOccurs = n;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setOccurence(int n) {
        this.occurence = n;
    }

    public void setId(String string) {
        this.firePropertyChange("id", this.id, string);
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setRequired(boolean bl) {
        this.firePropertyChange("required", this.required, bl);
        this.required = bl;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setNextSiblingId(String string) {
        this.firePropertyChange("nextSiblingId", this.siblingId, string);
        this.siblingId = string;
    }

    public String getNextSiblingId() {
        return this.siblingId;
    }

    public void resolveNextSibling() {
        if (this.node != null) {
            TreeNode treeNode = this.node.getNextSibling();
            while (treeNode != null) {
                GrammarNodeTreeNode grammarNodeTreeNode = (GrammarNodeTreeNode)treeNode;
                if (grammarNodeTreeNode.getUserObject() != null) {
                    AbstractXMLFormComponent abstractXMLFormComponent = (AbstractXMLFormComponent)grammarNodeTreeNode.getUserObject();
                    this.setNextSiblingId(abstractXMLFormComponent.id);
                    break;
                }
                treeNode = grammarNodeTreeNode.getNextSibling();
            }
        }
    }

    public void setError(String string) {
        this.setToolTipText(string);
        if (string == null) {
            this.setBorder(this.savedBorder);
            this.savedBorder = null;
        } else {
            if (this.savedBorder == null) {
                this.savedBorder = this.getBorder();
            }
            this.setBorder(new LineBorder(Color.RED));
        }
    }

    private AbstractXMLFormComponent getNextSiblingComponent() {
        return this.getNextSiblingComponent(false);
    }

    private AbstractXMLFormComponent getNextSiblingComponentWithDOMNode() {
        String string;
        AbstractXMLFormComponent abstractXMLFormComponent = this;
        while ((string = abstractXMLFormComponent.getNextSiblingId()) != null) {
            abstractXMLFormComponent = ((EditingContext)abstractXMLFormComponent.context).getComponentById(string);
            if (abstractXMLFormComponent == null) {
                return null;
            }
            if (abstractXMLFormComponent.dom == null) continue;
            return abstractXMLFormComponent;
        }
        return null;
    }

    private AbstractXMLFormComponent getNextSiblingComponent(boolean bl) {
        String string;
        AbstractXMLFormComponent abstractXMLFormComponent = this;
        while ((string = abstractXMLFormComponent.getNextSiblingId()) != null) {
            abstractXMLFormComponent = ((EditingContext)abstractXMLFormComponent.context).getComponentById(string);
            if (abstractXMLFormComponent == null) {
                return null;
            }
            if (!(!bl ? abstractXMLFormComponent.hasDOMParent() : abstractXMLFormComponent.getRequired())) continue;
            return abstractXMLFormComponent;
        }
        return null;
    }

    private AbstractXMLFormComponent getPreviousSiblingComponent() {
        return this.previousSiblingComponent;
    }

    public Node getDOMNextSibling(boolean bl) {
        AbstractXMLFormComponent abstractXMLFormComponent = this.getNextSiblingComponent(bl);
        if (abstractXMLFormComponent != null) {
            return abstractXMLFormComponent.getDOM();
        }
        return null;
    }

    public Node getDOMNextSibling() {
        return this.getDOMNextSibling(false);
    }

    public Node getDOM(Document document) {
        if (this.dom == null) {
            if (document == null) {
                try {
                    document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            if (this.getXpath() != null) {
                this.dom = XPathToolkit.buildNode(document, this.getXpath());
                if (this.dom != null) {
                    this.dom.setUserData("ui", this, null);
                }
            }
        }
        return this.dom;
    }

    public Node getDOM() {
        return this.getDOM(this.context.getDocument());
    }

    protected boolean hasDOMParent() {
        if (this.dom == null) {
            return false;
        }
        return this.dom.getParentNode() != null;
    }

    protected void setDOM(Node node) {
        this.dom = node;
        if (node != null) {
            node.setUserData("ui", this, null);
        }
    }

    protected void checkNodeIsBound(Node node, AbstractXMLFormComponent abstractXMLFormComponent) {
        if (abstractXMLFormComponent != null && node != null && node.getParentNode() == null) {
            if (abstractXMLFormComponent.getXMLFormComponentParent() != null) {
                Node node2 = abstractXMLFormComponent.getXMLFormComponentParent().getDOM();
                if (node2 != null) {
                    node = node2.getOwnerDocument().adoptNode(node);
                    if (node instanceof Attr) {
                        ((Element)node2).setAttributeNode((Attr)node);
                    } else {
                        AbstractXMLFormComponent abstractXMLFormComponent2 = abstractXMLFormComponent.getNextSiblingComponentWithDOMNode();
                        if (abstractXMLFormComponent2 == null) {
                            node2.appendChild(node);
                        } else {
                            Node node3 = abstractXMLFormComponent2.dom;
                            if (node3.getParentNode() == null) {
                                this.checkNodeIsBound(node3, abstractXMLFormComponent2);
                            }
                            if (abstractXMLFormComponent2.dom instanceof Attr) {
                                node2.appendChild(node);
                            } else {
                                node2.insertBefore(node, abstractXMLFormComponent2.dom);
                            }
                        }
                    }
                }
            } else if (this.context.getDocument().getDocumentElement() == null) {
                this.context.getDocument().appendChild(node);
            }
            this.checkNodeIsBound(node.getParentNode(), abstractXMLFormComponent.getXMLFormComponentParent());
        }
    }

    public boolean dispatchDOM(Node node) {
        if (node == null) {
            Container container = this.getComponentContainer();
            for (int i = 0; i < container.getComponentCount(); ++i) {
                ((AbstractXMLFormComponent)container.getComponent(i)).setDOM(null);
                ((AbstractXMLFormComponent)container.getComponent(i)).dispatchDOM(null);
            }
            return false;
        }
        String string = this.getXpath();
        if (string.endsWith("/text()")) {
            string = string.substring(0, string.length() - "/text()".length());
        }
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(string, node, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    arrayList.add(nodeList.item(i));
                }
                if (arrayList.size() > 1) {
                    AbstractXMLFormComponent abstractXMLFormComponent = this;
                    for (int i = 1; i < arrayList.size(); ++i) {
                        abstractXMLFormComponent = abstractXMLFormComponent.addSiblingComponent();
                        abstractXMLFormComponent.setDOM((Node)arrayList.get(i));
                        abstractXMLFormComponent.dispatchToChildren((Node)arrayList.get(i));
                    }
                }
                this.setDOM(nodeList.item(0));
                this.dispatchToChildren(nodeList.item(0));
                return true;
            }
            return false;
        }
        catch (XPathExpressionException xPathExpressionException) {
            return false;
        }
    }

    public void dispatchToChildren(Node node) {
        if (this instanceof XMLFormContainer) {
            Container container = this.getComponentContainer();
            Component[] componentArray = container.getComponents();
            boolean bl = false;
            if (componentArray != null) {
                for (int i = 0; i < componentArray.length; ++i) {
                    Component component = componentArray[i];
                    if (!(component instanceof AbstractXMLFormComponent)) continue;
                    ((AbstractXMLFormComponent)component).dispatchDOM(node);
                }
            }
        }
    }

    public boolean matchElement(AbstractXMLFormComponent abstractXMLFormComponent) {
        Node node = abstractXMLFormComponent.getDOM();
        if (this.getDOM().getNodeType() == node.getNodeType()) {
            return node.getNodeName().equals(this.getDOM().getNodeName());
        }
        return false;
    }

    private void checkListening() {
        if (!this.listening) {
            if (this.designMode) {
                this.addMouseMotionListener(this);
                this.addMouseListener(this);
                this.addPropertyChangeListener(this);
            }
            this.addHierarchyListener(this);
            this.listening = true;
        }
    }

    protected void checkOccurenceActions() {
        if (this.maxOccurs > 1) {
            boolean bl = false;
            if (this.occurence > this.minOccurs) {
                bl = true;
            }
            if (this.occurence < this.maxOccurs) {
                bl = true;
            }
            if (bl) {
                this.addRemoveButton = this.context.getComponentFactory().newAddDeleteComponent();
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout(0, 0, 0));
                jPanel.add(this.addRemoveButton);
                this.add((Component)jPanel, "West");
                this.invalidate();
                this.validate();
                this.addRemoveButton.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        AbstractXMLFormComponent.this.displayActionPopup(mouseEvent);
                    }
                });
            }
        }
    }

    private void displayActionPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        jMenuItem = this.context.getComponentFactory().newAddMenuItem();
        jPopupMenu.add(jMenuItem);
        jMenuItem.setText(Traductor.traduce("an", "Add a new") + " " + this.getDOM().getNodeName());
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(this.occurence < this.maxOccurs);
        jMenuItem = this.context.getComponentFactory().newDeleteMenuItem();
        jPopupMenu.add(jMenuItem);
        jMenuItem.setText(Traductor.traduce("del", "Delete this") + " " + this.getDOM().getNodeName());
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(this.occurence > this.minOccurs);
        jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkListening();
        if (!this.designMode) {
            this.checkOccurenceActions();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.removeHierarchyListener(this);
        this.removePropertyChangeListener(this);
        this.listening = false;
        this.listeningHierarchy = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("add".equals(actionEvent.getActionCommand())) {
            Node node = this.getDOMNextSibling();
            AbstractXMLFormComponent abstractXMLFormComponent = this.addSiblingComponent();
            if (abstractXMLFormComponent != null) {
                Node node2 = this.getXMLFormComponentParent().getDOM();
                Node node3 = abstractXMLFormComponent.getDOM(null);
                if (node3 instanceof Element) {
                    node3 = node3.cloneNode(true);
                    abstractXMLFormComponent.dom = node3 = this.context.getDocument().adoptNode(node3);
                    abstractXMLFormComponent.dispatchToChildren(node3);
                }
                if (node != null && node.getParentNode() == node2) {
                    node2.insertBefore(node3, node);
                } else {
                    node2.appendChild(node3);
                }
                this.context.action(0, abstractXMLFormComponent);
            }
        } else if ("delete".equals(actionEvent.getActionCommand())) {
            this.removeChild();
        }
    }

    public void removeXMLFormComponent(AbstractXMLFormComponent abstractXMLFormComponent) {
        GrammarNodeTreeNode grammarNodeTreeNode = abstractXMLFormComponent.getGrammarNode();
        if (grammarNodeTreeNode != null) {
            grammarNodeTreeNode.setUserObject(null);
        }
        Container container = this.getComponentContainer();
        container.remove(abstractXMLFormComponent);
    }

    public void removeChild() {
        String string = this.getNextSiblingId();
        AbstractXMLFormComponent abstractXMLFormComponent = this.getNextSiblingComponent();
        if (abstractXMLFormComponent != null && abstractXMLFormComponent.occurence == 0 && this.referenceComponent) {
            this.setDOM(null);
            this.dispatchToChildren(null);
            return;
        }
        AbstractXMLFormComponent abstractXMLFormComponent2 = this.getPreviousSiblingComponent();
        if (abstractXMLFormComponent2 != null && string != null) {
            abstractXMLFormComponent2.setNextSiblingId(string);
            ((EditingContext)abstractXMLFormComponent2.context).setComponentById(string, abstractXMLFormComponent);
        }
        DynamicLayout.remove(this.getParent(), this);
    }

    public AbstractXMLFormComponent addSiblingComponent() {
        String string = this.getNextSiblingId();
        AbstractXMLFormComponent abstractXMLFormComponent = this.getNextSiblingComponent();
        AbstractXMLFormComponent abstractXMLFormComponent2 = this.cloneIt();
        abstractXMLFormComponent2.previousSiblingComponent = this;
        abstractXMLFormComponent2.setId("" + abstractXMLFormComponent2.hashCode());
        this.setNextSiblingId(abstractXMLFormComponent2.getId());
        ((EditingContext)this.context).setComponentById(abstractXMLFormComponent2.getId(), abstractXMLFormComponent2);
        abstractXMLFormComponent2.setReferenceComponent(false);
        abstractXMLFormComponent2.setOccurence(this.occurence + 1);
        DynamicLayout.add(this.getParent(), this, abstractXMLFormComponent2);
        if (string != null) {
            abstractXMLFormComponent2.setNextSiblingId(string);
            if (abstractXMLFormComponent == null) {
                abstractXMLFormComponent = ((EditingContext)this.context).getComponentById(string);
            }
            ((EditingContext)abstractXMLFormComponent2.context).setComponentById(string, abstractXMLFormComponent);
        }
        return abstractXMLFormComponent2;
    }

    public void save(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = XMLSerializer.serialize(document, element, this);
        element.appendChild(element2);
    }

    public HashMap<String, PropertyChangeEvent> getModifiedProperties() {
        if (this.mapProperties == null) {
            this.mapProperties = new HashMap();
        }
        this.requiredProperties(this.mapProperties);
        return this.mapProperties;
    }

    protected void requiredProperties(HashMap<String, PropertyChangeEvent> hashMap) {
        hashMap.put("bounds", new PropertyChangeEvent(this, "bounds", null, this.getBounds()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (XMLDeserizalizer.isPropertyManaged(propertyChangeEvent.getNewValue())) {
            if (this.mapProperties == null) {
                this.mapProperties = new HashMap();
            }
            this.mapProperties.put(string, propertyChangeEvent);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        AbstractXMLFormComponent abstractXMLFormComponent;
        if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (abstractXMLFormComponent = this.getXMLFormComponentParent()) != null) {
            AbstractXMLFormComponent abstractXMLFormComponent2 = abstractXMLFormComponent;
            if (this.designMode && this.node != null) {
                String string = abstractXMLFormComponent2.getAbsoluteXPath();
                String string2 = XPathToolkit.getRelativeXPath(string, this.node.toXPath());
                this.setXpath(string2);
            }
        }
    }

    public void setTopComponent(boolean bl) {
        this.topComponent = bl;
    }

    public void setSelectedComponent(boolean bl) {
        this.selected = bl;
        if (!bl) {
            this.setBorder(new LineBorder(Color.BLACK));
        } else {
            this.setBorder(new LineBorder(Color.BLUE, 2));
            this.requestFocus();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setXpath(String string) {
        this.firePropertyChange("xpath", this.xpath, string);
        this.xpath = string;
        if (this.designMode) {
            this.updateLabel(this.resolveTitle());
        }
    }

    protected String resolveTitle() {
        return " xpath : " + this.xpath + " ";
    }

    protected void updateLabel(String string) {
        if (this.designMode) {
            if (this.label == null) {
                this.label = new JLabel(string);
                this.label.setFont(this.label.getFont().deriveFont(2, 10.0f));
                this.label.setOpaque(true);
                this.label.setBackground(Color.WHITE);
                this.label.setBorder(new LineBorder(Color.GRAY));
                this.add((Component)this.label, "North");
                this.invalidate();
                this.validate();
            } else {
                this.label.setText(string);
            }
        } else if (this.label == null) {
            this.label = new JLabel();
            this.label.setText(string);
            this.label.setOpaque(true);
            this.add((Component)this.label, "North");
            this.invalidate();
            this.validate();
        } else {
            this.label.setText(string);
        }
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getAbsoluteXPath() {
        if (this.xpath.startsWith("/")) {
            return this.xpath;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getXpath());
        for (AbstractXMLFormComponent abstractXMLFormComponent = this.getXMLFormComponentParent(); abstractXMLFormComponent != null; abstractXMLFormComponent = abstractXMLFormComponent.getXMLFormComponentParent()) {
            String string = abstractXMLFormComponent.getXpath();
            if (!"/".equals(string)) {
                stringBuffer.insert(0, string + "/");
                if (!string.startsWith("/")) continue;
                break;
            }
            stringBuffer.insert(0, "/");
        }
        return stringBuffer.toString();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.topComponent && this.firstResizeMouseEvent != null) {
            int n = this.getX();
            int n2 = this.getY();
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            switch (this.resizeMode) {
                case 1: {
                    int n5 = this.firstResizeMouseEvent.getY() - mouseEvent.getY();
                    n4 += n5;
                    n2 -= n5;
                    break;
                }
                case 2: {
                    int n6 = mouseEvent.getY() - this.firstResizeMouseEvent.getY();
                    n4 = this.initHeight + n6;
                    break;
                }
                case 3: {
                    int n7 = this.firstResizeMouseEvent.getX() - mouseEvent.getX();
                    n -= n7;
                    n3 += n7;
                    break;
                }
                case 4: {
                    int n8 = mouseEvent.getX() - this.firstResizeMouseEvent.getX();
                    n3 = this.initWidth + n8;
                    break;
                }
                case 5: {
                    int n9 = this.firstResizeMouseEvent.getY() - mouseEvent.getY();
                    int n10 = this.firstResizeMouseEvent.getX() - mouseEvent.getX();
                    n4 += n9;
                    n2 -= n9;
                    n -= n10;
                    n3 += n10;
                    break;
                }
                case 6: {
                    int n11 = this.firstResizeMouseEvent.getY() - mouseEvent.getY();
                    n4 += n11;
                    n2 -= n11;
                    int n12 = mouseEvent.getX() - this.firstResizeMouseEvent.getX();
                    n3 = this.initWidth + n12;
                    break;
                }
                case 7: {
                    int n13 = mouseEvent.getY() - this.firstResizeMouseEvent.getY();
                    n4 = this.initHeight + n13;
                    int n14 = this.firstResizeMouseEvent.getX() - mouseEvent.getX();
                    n -= n14;
                    n3 += n14;
                    break;
                }
                case 8: {
                    int n15 = mouseEvent.getY() - this.firstResizeMouseEvent.getY();
                    n4 = this.initHeight + n15;
                    int n16 = mouseEvent.getX() - this.firstResizeMouseEvent.getX();
                    n3 = this.initWidth + n16;
                    break;
                }
                case 9: {
                    int n17 = mouseEvent.getX() - this.firstResizeMouseEvent.getX();
                    int n18 = mouseEvent.getY() - this.firstResizeMouseEvent.getY();
                    n += n17;
                    n2 += n18;
                    break;
                }
            }
            this.resize(new Rectangle(n, n2, n3, n4));
        }
    }

    public void resize(Rectangle rectangle) {
        if (rectangle.width <= GridComponent.getGridSize() || rectangle.height <= GridComponent.getGridSize()) {
            return;
        }
        this.setBounds(rectangle);
        this.invalidate();
        this.validate();
        AbstractXMLFormComponent abstractXMLFormComponent = this.getXMLFormComponentParent();
        if (abstractXMLFormComponent.topComponent) {
            abstractXMLFormComponent.resetRootContainerSize();
        }
    }

    public void resetRootContainerSize() {
        Container container = this.getComponentContainer();
        if (container.getComponentCount() > 0) {
            Component component;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                component = container.getComponent(i);
                n = Math.max(n, component.getX() + component.getWidth());
                n2 = Math.max(n2, component.getY() + component.getHeight());
            }
            Container container2 = this.getParent();
            if (container2 instanceof JViewport) {
                component = (JViewport)container2;
                Rectangle rectangle = ((JViewport)component).getViewRect();
                n = Math.max(n, rectangle.width);
                n2 = Math.max(n2, rectangle.height);
                container2 = container2.getParent();
            }
            this.setPreferredSize(new Dimension(n, n2));
            container2.invalidate();
            container2.validate();
        }
    }

    public AbstractXMLFormComponent cloneIt() {
        try {
            Object object;
            Object object2;
            Element element = this.fieldDescription;
            if (element == null) {
                object2 = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object2).setNamespaceAware(true);
                object = ((DocumentBuilderFactory)object2).newDocumentBuilder().newDocument();
                element = XMLSerializer.serialize((Document)object, null, this);
            }
            object2 = new HashMap();
            object = new EditingContext((HashMap)object2){
                final /* synthetic */ HashMap val$components;
                {
                    this.val$components = hashMap;
                }

                @Override
                public AbstractXMLFormComponent getComponentById(String string) {
                    return (AbstractXMLFormComponent)this.val$components.get(string);
                }

                @Override
                public Collection<AbstractXMLFormComponent> getComponents() {
                    return this.val$components.values();
                }

                @Override
                public void setComponentById(String string, AbstractXMLFormComponent abstractXMLFormComponent) {
                    this.val$components.put(string, abstractXMLFormComponent);
                }

                @Override
                public XMLFormComponentFactory getComponentFactory() {
                    return AbstractXMLFormComponent.this.context.getComponentFactory();
                }

                @Override
                public GrammarNodeTreeNode getCurrentTreeNode() {
                    return AbstractXMLFormComponent.this.context.getCurrentTreeNode();
                }

                @Override
                public Document getDocument() {
                    return AbstractXMLFormComponent.this.context.getDocument();
                }

                @Override
                public void action(int n, Object object) {
                    AbstractXMLFormComponent.this.context.action(n, object);
                }
            };
            AbstractXMLFormComponent abstractXMLFormComponent = XMLDeserizalizer.build(element, this.designMode, null, (HashMap<String, AbstractXMLFormComponent>)object2, (ComponentContext)object, this.topComponent);
            return abstractXMLFormComponent;
        }
        catch (Exception exception) {
            ApplicationModel.debug(exception);
            return null;
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.topComponent || !this.designMode) {
            return;
        }
        int n = this.getResizeType(mouseEvent);
        switch (n) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 4: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 5: {
                this.setCursor(Cursor.getPredefinedCursor(6));
                break;
            }
            case 6: {
                this.setCursor(Cursor.getPredefinedCursor(7));
                break;
            }
            case 7: {
                this.setCursor(Cursor.getPredefinedCursor(4));
                break;
            }
            case 8: {
                this.setCursor(Cursor.getPredefinedCursor(5));
                break;
            }
            case 9: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            default: {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.activeAction();
        }
    }

    protected void activeAction() {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected boolean canBeResizedVertically() {
        return true;
    }

    private int getResizeType(MouseEvent mouseEvent) {
        int n = 0;
        n = mouseEvent.getX() < 5 && mouseEvent.getY() < 5 ? 5 : (mouseEvent.getX() > this.getWidth() - 5 && mouseEvent.getY() < 5 ? 6 : (mouseEvent.getX() < 5 && mouseEvent.getY() > this.getHeight() - 5 ? 7 : (mouseEvent.getX() > this.getWidth() - 5 && mouseEvent.getY() > this.getHeight() - 5 ? 8 : (mouseEvent.getX() < 5 ? 3 : (mouseEvent.getX() > this.getWidth() - 5 ? 4 : (mouseEvent.getY() < 5 ? 1 : (mouseEvent.getY() > this.getHeight() - 5 ? 2 : 9)))))));
        if (mouseEvent.getX() < 0 || mouseEvent.getX() > this.getWidth() || mouseEvent.getY() < 0 || mouseEvent.getY() > this.getHeight()) {
            n = 0;
        }
        if (!(this.canBeResizedVertically() || n != 5 && n != 2 && n != 7 && n != 8 && n != 1 && n != 5 && n != 6)) {
            n = 0;
        }
        return n;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.designMode) {
            this.context.action(0, this);
        }
        if (this.designMode && !this.topComponent) {
            this.resizeMode = this.getResizeType(mouseEvent);
            this.firstResizeMouseEvent = mouseEvent;
            this.initHeight = this.getHeight();
            this.initWidth = this.getWidth();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.resizeMode > 0) {
            this.resizeMode = 0;
            this.firstResizeMouseEvent = null;
            if (this.getParent() instanceof GridComponent) {
                GridComponent gridComponent = (GridComponent)this.getParent();
                gridComponent.resizeToGrid(this);
            }
        }
        this.context.action(0, this);
    }

    protected Component getNearest(Container container, Component component) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        Component component2 = null;
        int n3 = 0;
        int n4 = 0;
        if (component != null) {
            n3 = component.getY();
            n4 = component.getX();
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component3 = container.getComponent(i);
            if (component3 instanceof StaticXMLFormComponent || component3.getY() <= n3 && (component3.getY() != n3 || component3.getX() <= n4) || !(component3 instanceof AbstractXMLFormComponent) || component3.getY() > n2) continue;
            n2 = component3.getY();
            component2 = component3;
            if (component3.getY() != n2 || component3.getX() >= n) continue;
            n = component3.getX();
            component2 = component3;
        }
        return component2;
    }

    public boolean nextXMLFormFocus() {
        AbstractXMLFormComponent abstractXMLFormComponent;
        if (this.getXMLFormComponentParent() == null) {
            return false;
        }
        Component component = this.getNearest(this.getXMLFormComponentParent().getComponentContainer(), this);
        if (component != null) {
            if (component instanceof AbstractXMLFormComponent) {
                ((AbstractXMLFormComponent)component).requestFocus();
                return true;
            }
            return false;
        }
        for (abstractXMLFormComponent = this.getXMLFormComponentParent(); abstractXMLFormComponent != null && !abstractXMLFormComponent.nextXMLFormFocus(); abstractXMLFormComponent = abstractXMLFormComponent.getXMLFormComponentParent()) {
        }
        return abstractXMLFormComponent != null;
    }

    public void previousFocus() {
    }

    public PropertyDescriptor[] getProperties() {
        try {
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
            this.prepareProperties(arrayList);
            Collections.sort(arrayList, new Comparator<PropertyDescriptor>(){

                @Override
                public int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
                    return ("" + propertyDescriptor).compareTo("" + propertyDescriptor2);
                }
            });
            PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                propertyDescriptorArray[i] = arrayList.get(i);
            }
            return propertyDescriptorArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected void prepareProperties(ArrayList<PropertyDescriptor> arrayList) throws Exception {
        arrayList.add(!this.topComponent ? new XPropertyDescriptor(this) : null);
        arrayList.add(!this.topComponent ? new YPropertyDescriptor(this) : null);
        arrayList.add(!this.topComponent ? new WidthPropertyDescriptor(this) : null);
        arrayList.add(!this.topComponent ? new HeightPropertyDescriptor(this) : null);
        arrayList.add(new PropertyDescriptorImpl("background", Color.class, this));
        arrayList.add(new PropertyDescriptorImpl("foreground", Color.class, this));
        arrayList.add(new PropertyDescriptorImpl("font", Font.class, this));
        arrayList.add(new PropertyDescriptorImpl("required", Boolean.class, this));
        arrayList.add(new PropertyDescriptorImpl("xpath", String.class, this));
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.getId();
    }

    public void dumpDOM() {
        try {
            Document document = this.dom.getOwnerDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(document), new StreamResult(System.out));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            transformerFactoryConfigurationError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        FocusManager.setCurrentManager(new CustomFocusManager());
    }
}

