/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.universalbrowser;

import com.japisoft.universalbrowser.FileFilter;
import com.japisoft.universalbrowser.FileObjectTreeNode;
import com.japisoft.universalbrowser.FileView;
import com.japisoft.universalbrowser.TreeCellRendererImpl;
import com.japisoft.universalbrowser.UniversalBrowserListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.local.LocalFile;

public class JUniversalBrowserTree
extends JTree
implements TreeSelectionListener,
MouseListener,
MouseMotionListener {
    private boolean errorMode = false;
    private UniversalBrowserListener listener = null;

    public JUniversalBrowserTree() {
        this.setCellRenderer(new TreeCellRendererImpl());
    }

    public void addNotify() {
        super.addNotify();
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeTreeSelectionListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setFileView(FileView fileView) {
        ((TreeCellRendererImpl)this.getCellRenderer()).setFileView(fileView);
    }

    public void setFileFilter(FileFilter fileFilter) {
        ((TreeCellRendererImpl)this.getCellRenderer()).setFileFilter(fileFilter);
    }

    public FileObject getBrowsedFileObject() {
        if (this.getModel().getRoot() instanceof FileObjectTreeNode) {
            return ((FileObjectTreeNode)this.getModel().getRoot()).getSource();
        }
        return null;
    }

    public void browse(FileObject fileObject) {
        block5: {
            this.errorMode = false;
            if (fileObject instanceof LocalFile) {
                try {
                    if (!fileObject.exists()) {
                        this.errorMode = true;
                        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Can't find the root path")));
                        break block5;
                    }
                    this.setModel(new DefaultTreeModel(new FileObjectTreeNode(fileObject)));
                }
                catch (FileSystemException fileSystemException) {
                    this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Can't find the root path")));
                    this.errorMode = true;
                }
            } else {
                this.setModel(new DefaultTreeModel(new FileObjectTreeNode(fileObject)));
            }
        }
    }

    public void browse(String string) throws FileSystemException {
        FileSystemManager fileSystemManager = VFS.getManager();
        this.browse(fileSystemManager.resolveFile(string));
    }

    public void close() {
        try {
            if (this.getModel().getRoot() instanceof FileObjectTreeNode) {
                FileSystemManager fileSystemManager = VFS.getManager();
                fileSystemManager.closeFileSystem(((FileObjectTreeNode)this.getModel().getRoot()).getSource().getFileSystem());
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public void setUnivervalBrowserListener(UniversalBrowserListener universalBrowserListener) {
        this.listener = universalBrowserListener;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.errorMode) {
            return;
        }
        FileObjectTreeNode fileObjectTreeNode = (FileObjectTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        if (!fileObjectTreeNode.isRoot() && this.listener != null) {
            this.listener.select(fileObjectTreeNode.getSource());
        }
    }

    public FileObject getSelectedFileObject() {
        FileObjectTreeNode fileObjectTreeNode = (FileObjectTreeNode)this.getSelectionPath().getLastPathComponent();
        if (fileObjectTreeNode == null || fileObjectTreeNode.isRoot()) {
            return null;
        }
        return fileObjectTreeNode.getSource();
    }

    public void select(String string) {
        int n = string.lastIndexOf("!/");
        if (n > -1) {
            String string2 = string.substring(n + 2);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "/\\");
            TreeNode treeNode = (TreeNode)this.getModel().getRoot();
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            arrayList.add(treeNode);
            while (stringTokenizer.hasMoreTokens() && (treeNode = this.search(stringTokenizer.nextToken(), treeNode)) != null) {
                arrayList.add(treeNode);
            }
            this.setSelectionPath(new TreePath(arrayList.toArray()));
        }
    }

    private TreeNode search(String string, TreeNode treeNode) {
        for (int i = treeNode.getChildCount() - 1; i >= 0; --i) {
            TreeNode treeNode2 = treeNode.getChildAt(i);
            if (!treeNode2.toString().equals(string)) continue;
            return treeNode2;
        }
        return null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.errorMode) {
            return;
        }
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            FileObjectTreeNode fileObjectTreeNode = (FileObjectTreeNode)treePath.getLastPathComponent();
            FileObject fileObject = fileObjectTreeNode.getSource();
            this.setToolTipText(fileObject.getName().getURI());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        FileObjectTreeNode fileObjectTreeNode;
        if (this.errorMode) {
            return;
        }
        if (mouseEvent.getClickCount() >= 2 && this.listener != null && this.getSelectionPath() != null && (fileObjectTreeNode = (FileObjectTreeNode)this.getSelectionPath().getLastPathComponent()).isLeaf()) {
            this.listener.doubleClick(this.getSelectedFileObject());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) throws Throwable {
        FileSystemManager fileSystemManager = VFS.getManager();
        JUniversalBrowserTree jUniversalBrowserTree = new JUniversalBrowserTree();
        jUniversalBrowserTree.browse(fileSystemManager.resolveFile("file:///c:/titi/"));
        JFrame jFrame = new JFrame();
        jFrame.add(new JScrollPane(jUniversalBrowserTree));
        jFrame.setSize(300, 300);
        jFrame.setVisible(true);
    }
}

