/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.wizard;

import com.japisoft.framework.dialog.BasicDialogFooter;
import com.japisoft.framework.dialog.actions.AbstractDialogAction;
import com.japisoft.framework.dialog.actions.CancelAction;
import com.japisoft.framework.dialog.actions.DialogAction;
import com.japisoft.framework.dialog.actions.DialogActionModel;
import com.japisoft.framework.dialog.actions.OKAction;
import com.japisoft.framework.wizard.JWizard;
import com.japisoft.framework.wizard.TitledLabel;
import com.japisoft.framework.wizard.WizardStep;
import com.japisoft.framework.wizard.WizardStepModel;
import com.japisoft.framework.wizard.WizardView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DefaultWizardView
extends JComponent
implements WizardView {
    private JWizard wizard;
    private LeftPanel leftPanel = null;
    private CenterPanel centerPanel = null;
    private BottomPanel bottomPanel = null;
    private DialogAction previousAction;
    private DialogAction nextAction;
    private DialogAction okAction;
    private DialogAction cancelAction;
    private boolean init = false;
    private WizardStepModel delayedModel = null;
    private WizardStep delayedStep = null;

    public DefaultWizardView(JWizard jWizard) {
        this.wizard = jWizard;
    }

    public DialogAction getPreviousAction() {
        if (this.previousAction == null) {
            this.previousAction = new PreviousAction();
            this.previousAction.putValue("Name", this.wizard.getLabel("PREVIOUS", "Previous"));
        }
        return this.previousAction;
    }

    public DialogAction getNextAction() {
        if (this.nextAction == null) {
            this.nextAction = new NextAction();
            this.nextAction.putValue("Name", this.wizard.getLabel("NEXT", "Next"));
        }
        return this.nextAction;
    }

    public DialogAction getOkAction() {
        if (this.okAction == null) {
            this.okAction = new WizardOkAction();
        }
        return this.okAction;
    }

    public DialogAction getCancelAction() {
        if (this.cancelAction == null) {
            this.cancelAction = new WizardCancelAction();
        }
        return this.cancelAction;
    }

    public void addNotify() {
        super.addNotify();
        this.init();
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        this.setLayout(new BorderLayout());
        this.leftPanel = new LeftPanel();
        this.add((Component)this.leftPanel, "West");
        this.bottomPanel = new BottomPanel();
        this.add((Component)this.bottomPanel, "South");
        this.centerPanel = new CenterPanel();
        this.add((Component)this.centerPanel, "Center");
        if (!this.wizard.preparedDialog) {
            this.wizard.prepareWizards();
        }
        if (this.delayedModel != null) {
            this.updateView(this.delayedModel);
        }
        if (this.delayedStep != null) {
            this.activate(this.delayedStep);
        }
    }

    public JComponent getView() {
        return this;
    }

    public void updateView(WizardStepModel wizardStepModel) {
        if (!this.init) {
            this.delayedModel = wizardStepModel;
            return;
        }
        this.leftPanel.update(wizardStepModel);
    }

    public void activate(WizardStep wizardStep) {
        if (!this.init) {
            this.delayedStep = wizardStep;
            return;
        }
        this.leftPanel.show(wizardStep);
        this.centerPanel.show(wizardStep);
        int n = this.wizard.getWizardStepModel().getWizardStepIndex(wizardStep);
        int n2 = this.wizard.getWizardStepModel().getWizardStepCount();
        this.bottomPanel.setEnabledPrevious(n > 0);
        this.bottomPanel.setEnabledNext(n < n2 - 1);
        this.bottomPanel.setEnabledOk(n == n2 - 1);
    }

    public void setEnabledNextAction(boolean bl) {
        this.getNextAction().setEnabled(bl);
    }

    public void setEnabledPreviousAction(boolean bl) {
        this.getPreviousAction().setEnabled(bl);
    }

    class BottomPanel
    extends BasicDialogFooter {
        public BottomPanel() {
            DialogActionModel dialogActionModel = new DialogActionModel();
            dialogActionModel.addDialogAction(DefaultWizardView.this.getNextAction());
            dialogActionModel.addDialogAction(DefaultWizardView.this.getPreviousAction());
            dialogActionModel.addDialogAction(DefaultWizardView.this.getOkAction());
            dialogActionModel.addDialogAction(DefaultWizardView.this.getCancelAction());
            this.setModel(dialogActionModel);
        }

        public void setEnabledPrevious(boolean bl) {
            this.setEnabled(100, bl);
        }

        public void setEnabledNext(boolean bl) {
            this.setEnabled(101, bl);
        }

        public void setEnabledOk(boolean bl) {
            this.setEnabled(OKAction.ID, bl);
        }
    }

    class WizardCancelAction
    extends CancelAction {
        WizardCancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            DefaultWizardView.this.wizard.actionCancel();
        }
    }

    class WizardOkAction
    extends OKAction {
        WizardOkAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            DefaultWizardView.this.wizard.actionOk();
        }
    }

    class NextAction
    extends AbstractDialogAction {
        public NextAction() {
            super(101);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultWizardView.this.wizard.actionNext();
        }
    }

    class PreviousAction
    extends AbstractDialogAction {
        public PreviousAction() {
            super(100);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultWizardView.this.wizard.actionPrevious();
        }
    }

    class CenterPanel
    extends JPanel {
        TitledLabel l = null;
        JPanel v = null;

        public CenterPanel() {
            this.setLayout(new BorderLayout());
            if (DefaultWizardView.this.wizard.isWizardStepTitle()) {
                this.l = new TitledLabel();
                this.add((Component)this.l, "North");
            }
            this.v = new JPanel();
            this.v.setLayout(new BorderLayout());
            this.v.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add((Component)this.v, "Center");
        }

        public Dimension getPreferredSize() {
            return DefaultWizardView.this.wizard.getViewPreferredSize();
        }

        public void show(WizardStep wizardStep) {
            if (this.l != null) {
                this.l.setIcon(wizardStep.getLargeIcon());
                this.l.setText(wizardStep.getLongTitle() != null ? wizardStep.getLongTitle() : wizardStep.getShortTitle());
            }
            if (this.v.getComponentCount() > 0) {
                this.v.remove(0);
            }
            if (wizardStep.getStepView() == null) {
                throw new RuntimeException("No view for the step " + wizardStep.getName() + " !!");
            }
            JComponent jComponent = wizardStep.getStepView().getView();
            if (jComponent == null) {
                throw new RuntimeException("Your step " + wizardStep.getName() + " has now final view (getView). Please update the StepView implementation");
            }
            this.v.add((Component)wizardStep.getStepView().getView(), "Center");
            this.v.invalidate();
            this.v.validate();
            this.v.repaint();
        }
    }

    class LeftPanel
    extends JPanel {
        private JPanel p = null;

        public LeftPanel() {
            Color color = DefaultWizardView.this.wizard.getStepLabelsBackground();
            if (color != null) {
                this.setBackground(color);
            }
            this.setLayout(new BorderLayout());
            TitledLabel titledLabel = new TitledLabel();
            titledLabel.setText(DefaultWizardView.this.wizard.getLabel("STEPS", "Steps"));
            this.add((Component)titledLabel, "North");
            this.p = new JPanel();
            if (DefaultWizardView.this.wizard.getImage() == null) {
                if (color != null) {
                    this.p.setBackground(color);
                }
            } else {
                this.p.setOpaque(false);
            }
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.add((Component)this.p, "Center");
        }

        void show(WizardStep wizardStep) {
            JComponent jComponent;
            int n;
            for (n = 0; n < this.p.getComponentCount(); ++n) {
                jComponent = (JComponent)this.p.getComponent(n);
                jComponent.setEnabled(false);
            }
            n = DefaultWizardView.this.wizard.getWizardStepModel().getWizardStepIndex(wizardStep);
            if (n > -1) {
                jComponent = (JLabel)this.p.getComponent(n);
                jComponent.setEnabled(true);
            }
        }

        void update(WizardStepModel wizardStepModel) {
            this.p.removeAll();
            for (int i = 0; i < wizardStepModel.getWizardStepCount(); ++i) {
                WizardStep wizardStep = wizardStepModel.getWizardStep(i);
                String string = wizardStep.getShortTitle();
                if (string == null) {
                    string = DefaultWizardView.this.wizard.getLabel("STEP", "step");
                }
                if (DefaultWizardView.this.wizard.isNumberedStep()) {
                    string = i + 1 + ". " + string;
                }
                JLabel jLabel = new JLabel(string, wizardStep.getSmallIcon(), 2);
                jLabel.setOpaque(false);
                this.p.add(jLabel);
            }
            this.p.invalidate();
            this.p.validate();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (((DefaultWizardView)DefaultWizardView.this).wizard.image != null) {
                ((DefaultWizardView)DefaultWizardView.this).wizard.image.paintIcon(this, graphics, 0, 0);
            }
        }

        public Dimension getPreferredSize() {
            if (((DefaultWizardView)DefaultWizardView.this).wizard.image != null) {
                return new Dimension(((DefaultWizardView)DefaultWizardView.this).wizard.image.getIconWidth(), ((DefaultWizardView)DefaultWizardView.this).wizard.image.getIconHeight());
            }
            return DefaultWizardView.this.wizard.getLabelsPreferredSize();
        }
    }
}

