/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.preferences;

import com.japisoft.framework.dialog.BasicOKCancelDialogComponent;
import com.japisoft.framework.ui.TitleLabel;
import java.awt.Dialog;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontDialog
extends BasicOKCancelDialogComponent {
    private JTextField tfName;
    private JComboBox cbStyle = new JComboBox<Object>(new Object[]{"PLAIN", "BOLD", "ITALIC"});
    private JComboBox cbSize = new JComboBox<Object>(new Object[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "20"});
    public static boolean FONT_NAME_UPDATABLE = true;

    public FontDialog(Dialog dialog, Font font) {
        super(dialog, "Font", "Font choice", "Choose your font", null);
        this.initUI();
        this.setValue(font);
        this.setSize(250, 300);
    }

    private void initUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (FONT_NAME_UPDATABLE) {
            jPanel.add(new TitleLabel("Font name"));
            this.tfName = new JTextField();
            jPanel.add(this.tfName);
        } else {
            this.tfName = new JTextField();
        }
        jPanel.add(new TitleLabel("Font style"));
        jPanel.add(this.cbStyle);
        jPanel.add(new TitleLabel("Font size"));
        jPanel.add(this.cbSize);
        this.setUI(jPanel);
    }

    public void setValue(Font font) {
        this.tfName.setText(font.getName());
        if (font.getStyle() == 0) {
            this.cbStyle.setSelectedIndex(0);
        } else if (font.getStyle() == 1) {
            this.cbStyle.setSelectedIndex(1);
        } else if (font.getStyle() == 2) {
            this.cbStyle.setSelectedIndex(2);
        }
        this.cbSize.setSelectedIndex(font.getSize() - 10);
    }

    public Font getValue() {
        String string = this.tfName.getText();
        if ("".equals(string)) {
            string = "dialog";
        }
        return new Font(string, this.cbStyle.getSelectedIndex(), this.cbSize.getSelectedIndex() + 10);
    }
}

