/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.ComponentFactory;
import com.japisoft.framework.dockable.DockManager;
import com.japisoft.framework.dockable.Windowable;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.common.CommonAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;

class DefaultDockedFrame
extends JFrame
implements WindowListener {
    private Windowable panel;
    private Action source;
    private JToolBar tb;

    public DefaultDockedFrame(Action action, Windowable windowable) {
        int n;
        this.source = action;
        this.panel = windowable;
        JComponent jComponent = windowable.getContentPane();
        windowable.getView().remove(jComponent);
        this.getContentPane().add(jComponent);
        this.setDefaultCloseOperation(1);
        this.setTitle(windowable.getTitle());
        this.setSize(new Dimension(400, 400));
        this.addWindowListener(this);
        windowable.repaint();
        DockManager.storeDefaultDockedFrame(this);
        if (windowable.getFrameBounds() != null) {
            this.setBounds(windowable.getFrameBounds());
        }
        boolean bl = false;
        ActionModel actionModel = windowable.getActionModel();
        for (n = 0; n < actionModel.getActionCount(); ++n) {
            if (actionModel.getAction(n) instanceof CommonAction) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tb = new JToolBar();
            for (n = 0; n < actionModel.getActionCount(); ++n) {
                if (actionModel.getAction(n) instanceof CommonAction) continue;
                this.tb.add(ComponentFactory.getComponentFactory().buildButton(actionModel.getAction(n)));
            }
            this.getContentPane().add((Component)this.tb, "North");
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void undock() {
        this.removeWindowListener(this);
        JComponent jComponent = (JComponent)this.getContentPane().getComponent(0);
        this.getContentPane().remove(jComponent);
        this.panel.setContentPane(jComponent);
        if (this.source != null) {
            this.source.setEnabled(true);
        }
        this.panel.setFrameBounds(this.getBounds());
        DockManager.unstoreDefaultDockedFrame(this);
        this.dispose();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.undock();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void dispose() {
        super.dispose();
        this.panel = null;
        this.source = null;
        if (this.tb != null) {
            this.tb.removeAll();
            this.tb = null;
        }
    }
}

