/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dockable;

import com.japisoft.framework.dockable.DefaultDockedFrame;
import com.japisoft.framework.dockable.DefaultTitleBar;
import com.japisoft.framework.dockable.DockableFrameTitleBar;
import com.japisoft.framework.dockable.Windowable;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ComponentFactory {
    private static ComponentFactory SINGLETON = null;
    private boolean autoScrollMode = false;

    public static void setComponentFactory(ComponentFactory componentFactory) {
        SINGLETON = componentFactory;
    }

    public static ComponentFactory getComponentFactory() {
        if (SINGLETON == null) {
            SINGLETON = new ComponentFactory();
        }
        return SINGLETON;
    }

    public void setAutoScrollMode(boolean bl) {
        this.autoScrollMode = bl;
    }

    public JButton buildButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setBorderPainted(false);
        jButton.setBorder(null);
        jButton.setOpaque(false);
        return jButton;
    }

    public DockableFrameTitleBar buildTitleBar(String string) {
        return new DefaultTitleBar(string);
    }

    public JFrame buildDockedFrame(Action action, Windowable windowable) {
        return new DefaultDockedFrame(action, windowable);
    }

    public JComponent buildContentPaneForFrame() {
        if (this.autoScrollMode) {
            return new JScrollPane();
        }
        return new JPanel();
    }
}

