/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.dialog;

import com.japisoft.framework.dialog.DialogComponent;
import com.japisoft.framework.dialog.DialogFooter;
import com.japisoft.framework.dialog.DialogHeader;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.dialog.actions.CancelAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class BasicDialogComponent
extends JDialog
implements WindowListener,
DialogComponent {
    private DialogFooter footer = null;
    Dimension iniDim = null;
    private int lastAction = CancelAction.ID;

    public BasicDialogComponent(String string) {
        this.setTitle(string);
        this.setModal(true);
        this.init();
    }

    public BasicDialogComponent(Dialog dialog, String string) {
        super(dialog, string);
        this.setModal(true);
        this.init();
    }

    public BasicDialogComponent(Frame frame, String string) {
        super(frame, string);
        this.setModal(true);
        this.init();
    }

    private void init() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicDialogComponent.this.setLastAction(DialogManager.getDefaultClosingAction());
                BasicDialogComponent.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getContentPane().setLayout(new BorderLayout(5, 10));
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setLastAction(CancelAction.ID);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void addNotify() {
        super.addNotify();
        this.addWindowListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeWindowListener(this);
    }

    public void setInitialSize(int n, int n2) {
        this.iniDim = new Dimension(n, n2);
    }

    public DialogComponent init(DialogHeader dialogHeader, JComponent jComponent, DialogFooter dialogFooter) {
        if (dialogHeader != null) {
            this.getContentPane().add((Component)dialogHeader.getView(), "North");
        }
        if (jComponent != null) {
            this.getContentPane().add((Component)jComponent, "Center");
            if (this.iniDim != null) {
                jComponent.setPreferredSize(this.iniDim);
            }
        }
        if (dialogFooter != null) {
            this.footer = dialogFooter;
            this.getContentPane().add((Component)dialogFooter.getView(), "South");
        }
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        return this;
    }

    public void setSize(int n, int n2, boolean bl) {
        super.setSize(n, n2);
        if (bl) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        }
    }

    public void setLastAction(int n) {
        this.lastAction = n;
        this.actionPerformed(n);
    }

    protected void actionPerformed(int n) {
    }

    public int getLastAction() {
        return this.lastAction;
    }

    public void invokeAction(int n) {
        this.footer.invokeAction(n);
    }

    protected void beforeClosing() {
        this.footer.dialogHidden();
    }

    protected void beforeShowing() {
        if (this.footer != null) {
            this.footer.dialogShown();
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.beforeShowing();
        }
        try {
            super.setVisible(bl);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException.getMessage());
        }
    }

    public void setEnabled(int n, boolean bl) {
        if (this.footer != null) {
            this.footer.setEnabled(n, bl);
        }
    }

    public boolean isOk() {
        return this.getLastAction() == DialogManager.OK_ID;
    }

    public boolean isCancel() {
        return this.getLastAction() == DialogManager.CANCEL_ID;
    }

    public void dispose() {
        if (this.footer != null) {
            this.beforeClosing();
            super.dispose();
            this.footer.dispose();
            this.footer = null;
        }
    }

    public void dispose(int n) {
        this.lastAction = n;
        this.setVisible(false);
        this.dispose();
    }

    public Component getView() {
        return this;
    }
}

