/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.walker;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.ValidCriteria;

public class AttributeCriteria
implements ValidCriteria {
    private String attribute;
    private String value;
    public static String ANY_ATTRIBUTE = "*";
    private boolean namespace = false;
    private boolean ignoreAttribute = false;

    public AttributeCriteria(String string) {
        this.attribute = string;
        if (string == null) {
            throw new RuntimeException("Invalid criteria attribute");
        }
    }

    public AttributeCriteria(String string, String string2) {
        this.attribute = string;
        this.value = string2;
        this.ignoreAttribute = ANY_ATTRIBUTE.equals(string);
        if (string == null || string2 == null) {
            throw new RuntimeException("Invalid criteria attribute name & value");
        }
    }

    public AttributeCriteria(String string, String string2, boolean bl) {
        this(string, string2);
        int n;
        this.namespace = bl;
        if (bl && string2 != null && (n = string2.indexOf(":")) > -1) {
            try {
                this.value = string2.substring(n + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(SimpleNode simpleNode) {
        if (!simpleNode.isTag()) return false;
        if (!this.ignoreAttribute) {
            if (this.value == null) {
                return simpleNode.hasAttribute(this.attribute);
            }
            String string = simpleNode.getAttribute(this.attribute);
            if (string == null) {
                return false;
            }
            boolean bl = this.value.equals(string);
            if (bl) return true;
            if (!this.namespace) return false;
            int n = string.indexOf(":");
            if (n <= -1) return false;
            try {
                string = string.substring(n + 1);
                return this.value.equals(string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
        }
        for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
            String string = simpleNode.getViewAttributeAt(i);
            if (!this.value.equals(simpleNode.getAttribute(string))) continue;
            return true;
        }
        return false;
    }
}

