/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.tools;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import java.util.Vector;
import javax.swing.tree.TreePath;

public final class XMLToolkit {
    public static SimpleNode getNodeForLine(Document document, int n) {
        SimpleNode simpleNode;
        FastVector fastVector = document.getFlatNodes();
        if (fastVector == null) {
            throw new RuntimeException("Invalid usage for getNodeForLine : No flatView mode ");
        }
        int n2 = 0;
        SimpleNode simpleNode2 = null;
        while ((simpleNode = (SimpleNode)fastVector.get(n2)).getStartingLine() <= n) {
            if (n >= simpleNode.getStartingLine() && n <= simpleNode.getStoppingLine()) {
                simpleNode2 = simpleNode;
            }
            if (++n2 < fastVector.size()) continue;
            if (simpleNode2 != null) break;
            simpleNode2 = simpleNode;
            break;
        }
        return simpleNode2;
    }

    public static SimpleNode getNodeForOffset(Document document, int n) {
        SimpleNode simpleNode;
        if (document == null) {
            return null;
        }
        FastVector fastVector = document.getFlatNodes();
        if (fastVector == null) {
            throw new RuntimeException("Invalid usage for getNodeForLine : No flatView mode ");
        }
        int n2 = 0;
        SimpleNode simpleNode2 = null;
        SimpleNode simpleNode3 = (SimpleNode)document.getRoot();
        if (simpleNode3.getStartingOffset() > n || simpleNode3.getStoppingOffset() < n) {
            return null;
        }
        int n3 = 0;
        while ((simpleNode = (SimpleNode)fastVector.get(n2)).getStartingOffset() <= n) {
            n3 = simpleNode.isText() ? 1 : 0;
            if (n > simpleNode.getStartingOffset() - n3 && n <= simpleNode.getStoppingOffset()) {
                simpleNode2 = simpleNode;
            }
            if (++n2 < fastVector.size()) continue;
            if (simpleNode2 != null) break;
            simpleNode2 = simpleNode;
            break;
        }
        return simpleNode2;
    }

    public static String[] getQualifiedPath(SimpleNode simpleNode) {
        if (simpleNode == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        while (simpleNode != null) {
            vector.insertElementAt(simpleNode.getQualifiedContent(), 0);
            simpleNode = simpleNode.getSimpleParent();
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static TreePath getTreePath(SimpleNode simpleNode) {
        Vector<SimpleNode> vector = new Vector<SimpleNode>();
        while (simpleNode != null) {
            vector.insertElementAt(simpleNode, 0);
            simpleNode = simpleNode.getSimpleParent();
        }
        if (vector.size() == 0) {
            return null;
        }
        return new TreePath(vector.toArray());
    }

    public static SimpleNode getMatchingNode(SimpleNode simpleNode, String[] stringArray) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            SimpleNode simpleNode2 = simpleNode.childAt(i);
            if (!simpleNode2.isTag()) continue;
            String string = simpleNode2.getNodeContent();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                return simpleNode2;
            }
        }
        return null;
    }

    public static String resolveCharEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '&' && (i + 1 >= string.length() || string.charAt(i + 1) != '#')) {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#10;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

