/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.icl.saxon.Context;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.trace.TraceListener;
import com.japisoft.editix.ui.xslt.debug.DebugContext;
import com.japisoft.editix.ui.xslt.debug.DebugElement;
import com.japisoft.editix.ui.xslt.debug.DebugVariable;
import com.japisoft.editix.xslt.debug.CommonTraceListener;
import com.japisoft.editix.xslt.debug.ContextVariable;
import com.japisoft.editix.xslt.debug.NodeDebug;
import com.japisoft.editix.xslt.debug.Saxon1NodeDebug;
import com.japisoft.editix.xslt.debug.Saxon2NodeDebug;
import com.japisoft.editix.xslt.debug.XPathContextNode;
import com.japisoft.xmlpad.IXMLPanel;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;

public class SaxonTraceListener
extends CommonTraceListener
implements net.sf.saxon.trace.TraceListener,
TraceListener {
    private static String NAMESPACE_XSLT = "http://www.w3.org/1999/XSL/Transform";
    private ArrayList stack = null;
    private ArrayList storedVariables = null;

    public SaxonTraceListener(IXMLPanel iXMLPanel) {
        super(iXMLPanel);
    }

    public void open() {
    }

    public void close() {
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }

    public static String getPrettyLocalName(NodeDebug nodeDebug) {
        if (NAMESPACE_XSLT.equals(nodeDebug.getNamespace())) {
            String string = nodeDebug.getLocalName();
            if ("template".equals(nodeDebug.getLocalName())) {
                if (nodeDebug.getAttributeValue("match") != null) {
                    string = string + " [" + nodeDebug.getAttributeValue("match") + "]";
                } else if (nodeDebug.getAttributeValue("name") != null) {
                    string = string + " [" + nodeDebug.getAttributeValue("name") + "]";
                }
            } else if ("value-of".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("select") + "]";
            } else if ("if".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("test") + "]";
            } else if ("variable".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("name") + "]";
            } else if ("param".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("name") + "]";
            } else if ("for-each".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("select") + "]";
            } else if ("apply-templates".equals(nodeDebug.getLocalName())) {
                if (nodeDebug.getAttributeValue("select") != null) {
                    string = string + " [" + nodeDebug.getAttributeValue("select") + "]";
                }
            } else if ("call-template".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("name") + "]";
            } else if ("sequence".equals(nodeDebug.getLocalName())) {
                string = string + " [" + nodeDebug.getAttributeValue("select") + "]";
            }
            return string;
        }
        return nodeDebug.getLocalName();
    }

    public void enter(NodeDebug nodeDebug) {
        if (this.noWait || nodeDebug.getLocalName() == null) {
            return;
        }
        if (this.stack == null) {
            this.stack = new ArrayList();
        }
        this.stack.add(new DebugElement(SaxonTraceListener.getPrettyLocalName(nodeDebug), nodeDebug.getLineNumber(), !NAMESPACE_XSLT.equals(nodeDebug.getNamespace()), nodeDebug.getSystemUri()));
        boolean bl = this.continueMode;
        if (this.bmContext.matchLine(nodeDebug.getSystemUri(), nodeDebug.getLineNumber() - 1, this.panel.getMainContainer())) {
            bl = true;
        }
        if (bl || this.continueMode) {
            ArrayList<DebugElement> arrayList = null;
            ArrayList arrayList2 = nodeDebug.getXPathContext();
            if (arrayList2 != null) {
                arrayList = new ArrayList<DebugElement>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    XPathContextNode xPathContextNode = (XPathContextNode)arrayList2.get(i);
                    arrayList.add(new DebugElement(xPathContextNode.getName(), xPathContextNode.getLineNumber(), !xPathContextNode.currentOne(), nodeDebug.getSystemUri()));
                }
            }
            ArrayList<DebugVariable> arrayList3 = null;
            arrayList2 = nodeDebug.getVariables();
            if (arrayList2 != null) {
                arrayList3 = new ArrayList<DebugVariable>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ContextVariable contextVariable = (ContextVariable)arrayList2.get(i);
                    arrayList3.add(new DebugVariable(contextVariable.getName(), contextVariable.getType(), contextVariable.getValue(), contextVariable.getLine()));
                }
            }
            ArrayList<DebugVariable> arrayList4 = null;
            arrayList2 = nodeDebug.getParameters();
            if (arrayList2 != null) {
                arrayList4 = new ArrayList<DebugVariable>();
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ContextVariable contextVariable = (ContextVariable)arrayList2.get(i);
                    arrayList4.add(new DebugVariable(contextVariable.getName(), contextVariable.getType(), contextVariable.getValue(), contextVariable.getLine()));
                }
            }
            this.panel.setProperty("xslt.debug", new DebugContext(nodeDebug.getSystemUri(), this.stack, arrayList, arrayList3, arrayList4));
            this.unhighLight(true);
            this.showCurrentLine(nodeDebug.getSystemUri(), nodeDebug.getLineNumber() - 1);
            this.refreshResult();
            this.waitForDebug();
        }
    }

    public void enter(InstructionInfo instructionInfo, XPathContext xPathContext) {
        Iterator iterator = instructionInfo.getProperties();
        while (iterator.hasNext()) {
            System.out.println("- Property = " + iterator.next());
        }
        this.enter(new Saxon2NodeDebug(instructionInfo, xPathContext));
    }

    public void enter(NodeInfo nodeInfo, Context context) {
        this.enter(new Saxon1NodeDebug(nodeInfo, context));
    }

    public void leave(InstructionInfo instructionInfo) {
    }

    public void enterSource(NodeHandler nodeHandler, Context context) {
    }

    public void leave(NodeInfo nodeInfo, Context context) {
    }

    public void leaveSource(NodeHandler nodeHandler, Context context) {
    }

    public void toplevel(NodeInfo nodeInfo) {
    }
}

