/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.xsd.view;

import com.japisoft.editix.ui.xsd.Factory;
import com.japisoft.editix.ui.xsd.toolkit.SchemaHelper;
import com.japisoft.editix.ui.xsd.view.CommonSelectionListener;
import com.japisoft.editix.ui.xsd.view.View;
import com.japisoft.editix.ui.xsd.view.designer.LeftToRightLayout;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponent;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponentFactory;
import com.japisoft.editix.ui.xsd.view.designer.XSDComponentListener;
import com.japisoft.editix.ui.xsd.view.designer.container.XSDContainerComponentImpl;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DesignerViewImpl
extends JComponent
implements View,
XSDComponentListener {
    private Factory factory;
    private Element initE;
    private XSDComponent ui;
    private boolean canInit = true;
    private XSDComponent selectedComponent;
    private static Font backFont = new Font("arial", 0, 10);
    private CommonSelectionListener designerListener = null;
    private Element lastSelectedElement;
    private static Font cardinalFont = new Font("arial", 0, 8);

    public DesignerViewImpl(Factory factory) {
        this.factory = factory;
        this.setLayout(new LeftToRightLayout());
    }

    public void init(Element element) {
        this.disposeAll();
        this.initE = element;
        this.ui = XSDComponentFactory.getComponent(element, this);
        this.canInit = true;
        if (this.ui != null) {
            this.add(this.ui.getView());
            this.select(this.ui);
            this.ui.setOpened(false);
            this.openClose(this.ui);
        } else {
            this.canInit = false;
        }
        this.repaint();
    }

    public boolean canInit() {
        return this.canInit;
    }

    public void refreshCurrentElementUI() {
        if (this.selectedComponent != null) {
            this.selectedComponent.updateUIContentCache();
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void goInto(XSDComponent xSDComponent) {
        if (!(this.openReference(xSDComponent) || this.openType(xSDComponent) || xSDComponent.isOpened())) {
            this.openClose(xSDComponent);
        }
    }

    public void openClose(XSDComponent xSDComponent) {
        Container container = xSDComponent.getView().getParent();
        if (xSDComponent instanceof XSDContainerComponentImpl) {
            container = xSDComponent.getView();
        }
        if (xSDComponent.isOpened()) {
            Element element = xSDComponent.getElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                XSDComponent xSDComponent2;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || (xSDComponent2 = (XSDComponent)(element2 = (Element)node).getUserData("ui")) == null) continue;
                xSDComponent2.remove(false);
            }
            xSDComponent.setOpened(false);
            xSDComponent.getView().invalidate();
        } else {
            int n;
            ArrayList<XSDComponent> arrayList = null;
            Element element = xSDComponent.getElement();
            NodeList nodeList = element.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                Element element3;
                XSDComponent xSDComponent3;
                Node node = nodeList.item(n);
                if (!(node instanceof Element) || (xSDComponent3 = XSDComponentFactory.getComponent(element3 = (Element)node, this)) == null) continue;
                container.add(xSDComponent3.getView());
                if (xSDComponent3.isOpened()) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<XSDComponent>();
                    }
                    arrayList.add(xSDComponent3);
                }
                xSDComponent3.getView().invalidate();
            }
            if (arrayList != null) {
                for (n = 0; n < arrayList.size(); ++n) {
                    ((XSDComponent)arrayList.get(n)).setOpened(false);
                    this.openClose((XSDComponent)arrayList.get(n));
                }
            }
            xSDComponent.setOpened(true);
        }
        this.validate();
        this.revalidate();
        this.repaint();
    }

    public void openAll(XSDComponent xSDComponent) {
        if (!xSDComponent.isOpened()) {
            this.openClose(xSDComponent);
        }
        Element element = xSDComponent.getElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || !((element2 = (Element)nodeList.item(i)).getUserData("ui") instanceof XSDComponent)) continue;
            this.openAll((XSDComponent)element2.getUserData("ui"));
        }
    }

    public void select(XSDComponent xSDComponent) {
        if (this.selectedComponent != null) {
            this.selectedComponent.setSelected(false);
        }
        this.selectedComponent = xSDComponent;
        this.selectedComponent.setSelected(true);
        if (this.designerListener != null) {
            this.designerListener.select(xSDComponent.getElement());
        }
    }

    public boolean openReference(XSDComponent xSDComponent) {
        Element element = xSDComponent.getElement();
        return this.openReference(element);
    }

    public boolean openReference(Element element) {
        Element element2 = SchemaHelper.getAnyByName(element.getOwnerDocument().getDocumentElement(), element.getAttribute("ref"));
        if (element2 != null) {
            this.designerListener.openDesigner(element2);
            return true;
        }
        return false;
    }

    public boolean openType(XSDComponent xSDComponent) {
        Element element = xSDComponent.getElement();
        return this.openType(element);
    }

    public boolean openType(Element element) {
        Element element2 = SchemaHelper.getComplexTypeByName(element.getOwnerDocument().getDocumentElement(), element.getAttribute("type"));
        if (element2 != null) {
            this.designerListener.openDesigner(element2);
            return true;
        }
        return false;
    }

    public boolean open(Element element) {
        if (!this.openReference(element)) {
            return this.openType(element);
        }
        return true;
    }

    public void moveDown(XSDComponent xSDComponent) {
        Element element = xSDComponent.getElement();
        Element element2 = (Element)element.getParentNode();
        NodeList nodeList = element2.getChildNodes();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) == element) {
                bl2 = true;
                continue;
            }
            if (!(nodeList.item(i) instanceof Element) || !bl2 || i + 1 >= nodeList.getLength()) continue;
            element2.removeChild(element);
            element2.insertBefore(element, nodeList.item(i));
            bl = true;
            break;
        }
        if (!bl) {
            element2.removeChild(element);
            element2.appendChild(element);
        }
        XSDComponent xSDComponent2 = (XSDComponent)element2.getUserData("ui");
        xSDComponent2.setOpened(true);
        this.openClose(xSDComponent2);
        this.openClose(xSDComponent2);
    }

    public void moveUp(XSDComponent xSDComponent) {
        Element element = xSDComponent.getElement();
        Element element2 = (Element)element.getParentNode();
        NodeList nodeList = element2.getChildNodes();
        Node node = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) == element) {
                if (node == null) break;
                element2.removeChild(element);
                element2.insertBefore(element, node);
                break;
            }
            if (!(nodeList.item(i) instanceof Element)) continue;
            node = nodeList.item(i);
        }
        this.refreshContent(element2);
    }

    public void refreshContent(Element element) {
        XSDComponent xSDComponent = (XSDComponent)element.getUserData("ui");
        if (xSDComponent != null) {
            xSDComponent.setOpened(true);
            this.openClose(xSDComponent);
            this.openClose(xSDComponent);
        }
    }

    public void moveAfter(XSDComponent xSDComponent, XSDComponent xSDComponent2) {
        Element element = xSDComponent.getElement();
        xSDComponent.remove(false);
        element.setUserData("ui", null, null);
        element.getParentNode().removeChild(element);
        Element element2 = xSDComponent2.getElement();
        Element element3 = (Element)element2.getParentNode();
        NodeList nodeList = element3.getChildNodes();
        Element element4 = null;
        boolean bl = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element5 = (Element)nodeList.item(i);
            if (element5 == element2) {
                bl = true;
                break;
            }
            if (!bl) continue;
            element4 = element5;
            break;
        }
        if (element4 == null) {
            element3.appendChild(element);
        } else {
            element3.insertBefore(element, element4);
        }
        this.refreshContent(element);
        this.refreshContent(element3);
    }

    public void moveBefore(XSDComponent xSDComponent, XSDComponent xSDComponent2) {
        Element element = xSDComponent.getElement();
        xSDComponent.remove(false);
        element.setUserData("ui", null, null);
        element.getParentNode().removeChild(element);
        Element element2 = xSDComponent2.getElement();
        Element element3 = (Element)element2.getParentNode();
        element3.insertBefore(element, element2);
        this.refreshContent(element);
        this.refreshContent(element3);
    }

    public void moveInto(XSDComponent xSDComponent, XSDComponent xSDComponent2) {
        Element element = xSDComponent.getElement();
        xSDComponent.remove(false);
        element.setUserData("ui", null, null);
        Element element2 = (Element)element.getParentNode();
        element2.removeChild(element);
        Element element3 = xSDComponent2.getElement();
        element3.appendChild(element);
        this.refreshContent(element3);
        this.refreshContent(element2);
    }

    public void addXMLChild(XSDComponent xSDComponent, String string) {
        Element element = SchemaHelper.createTag(xSDComponent.getElement(), string);
        String string2 = element.getLocalName();
        if ("element".equals(string2)) {
            element.setAttribute("name", "myElement");
        } else if ("attribute".equals(string2)) {
            element.setAttribute("name", "myAttribute");
        }
        boolean bl = false;
        Element element2 = xSDComponent.getElement();
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3;
            String string3;
            if (!(nodeList.item(i) instanceof Element) || !"attribute".equals(string3 = (element3 = (Element)nodeList.item(i)).getLocalName()) && !"attributeGroup".equals(string3) && !"anyAttribute".equals(string3) && !"key".equals(string3) && !"keyref".equals(string3) && !"unique".equals(string3)) continue;
            element2.insertBefore(element, element3);
            bl = true;
            break;
        }
        if (!bl) {
            xSDComponent.getElement().appendChild(element);
        }
        xSDComponent.setOpened(true);
        this.openClose(xSDComponent);
        this.openClose(xSDComponent);
        XSDComponent xSDComponent2 = (XSDComponent)element.getUserData("ui");
        if (xSDComponent2 != null) {
            this.select(xSDComponent2);
        }
    }

    public void deleteXML(XSDComponent xSDComponent) {
        Element element = (Element)xSDComponent.getElement().getParentNode();
        element.removeChild(xSDComponent.getElement());
        xSDComponent.remove(true);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void popup(XSDComponent xSDComponent, int n, int n2) {
        ActionPopup actionPopup = new ActionPopup(xSDComponent);
        actionPopup.show(xSDComponent.getView(), n, n2);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.initE != null && !(this.initE.getUserData("ui") instanceof XSDContainerComponentImpl)) {
            graphics.setColor(Color.DARK_GRAY);
            DesignerViewImpl.drawElementLines(this.initE, graphics);
        }
    }

    public JComponent getView() {
        return this;
    }

    public void setCommonSelectionListener(CommonSelectionListener commonSelectionListener) {
        this.designerListener = commonSelectionListener;
    }

    public void dispose() {
        this.initE = null;
        this.designerListener = null;
        this.lastSelectedElement = null;
        this.selectedComponent = null;
    }

    public void stopEditing() {
    }

    public void disposeAll() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((XSDComponent)((Object)this.getComponent(i))).dispose();
        }
        this.removeAll();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public static void drawElementLines(Element element, Graphics graphics) {
        XSDComponent xSDComponent = (XSDComponent)element.getUserData("ui");
        if (xSDComponent != null) {
            if (xSDComponent instanceof XSDContainerComponentImpl) {
                DesignerViewImpl.drawElementLine(element, new Rectangle(0, xSDComponent.getView().getHeight() / 2, 0, 0), graphics, true);
            } else {
                DesignerViewImpl.drawElementLine(element, xSDComponent.getView().getBounds(), graphics, false);
            }
        }
    }

    private static void drawElementLine(Element element, Rectangle rectangle, Graphics graphics, boolean bl) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            XSDComponent xSDComponent;
            if (!(nodeList.item(i) instanceof Element) || (xSDComponent = (XSDComponent)(element2 = (Element)nodeList.item(i)).getUserData("ui")) == null) continue;
            JComponent jComponent = xSDComponent.getView();
            double d = rectangle.getWidth() + rectangle.getX();
            double d2 = (d + (double)jComponent.getX()) / 2.0;
            double d3 = rectangle.getHeight() / 2.0 + rectangle.getY();
            double d4 = jComponent.getY() + jComponent.getHeight() / 2;
            if (d4 == d3 + 0.5) {
                d3 += 1.0;
            }
            graphics.drawLine((int)d, (int)d3, (int)d2, (int)d3);
            graphics.drawLine((int)d2, (int)d3, (int)d2, (int)d4);
            graphics.drawLine((int)d2, (int)d4, jComponent.getX(), (int)d4);
            DesignerViewImpl.drawElementCardinalities(element2, jComponent, graphics);
            if (!bl || xSDComponent instanceof XSDContainerComponentImpl) continue;
            DesignerViewImpl.drawElementLine(element2, jComponent.getBounds(), graphics, true);
        }
    }

    private static void drawElementCardinalities(Element element, JComponent jComponent, Graphics graphics) {
        if (element.hasAttribute("minOccurs") || element.hasAttribute("maxOccurs")) {
            int n = 1;
            int n2 = 1;
            String string = "" + n2;
            try {
                n = Integer.parseInt(element.getAttribute("minOccurs"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string2 = "" + n;
            if ("unbounded".equals(element.getAttribute("maxOccurs"))) {
                string = "oo";
            } else {
                try {
                    n2 = Integer.parseInt(element.getAttribute("maxOccurs"));
                    string = "" + n2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            Font font = graphics.getFont();
            graphics.setFont(cardinalFont);
            FontMetrics fontMetrics = graphics.getFontMetrics(cardinalFont);
            int n3 = fontMetrics.stringWidth(string2 + ".." + string);
            graphics.drawString(string2 + ".." + string, jComponent.getX() + jComponent.getWidth() - n3 - 15, jComponent.getY() + jComponent.getHeight() + fontMetrics.getAscent() + 1);
            graphics.setFont(font);
        }
    }

    class ActionPopup
    extends JPopupMenu
    implements ActionListener {
        private XSDComponent component;

        ActionPopup(XSDComponent xSDComponent) {
            JMenuItem jMenuItem;
            Object object;
            this.component = xSDComponent;
            JMenu jMenu = new JMenu("Add child");
            this.add(jMenu);
            String[] stringArray = SchemaHelper.getChildrenForElement(xSDComponent.getElement());
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = new JMenuItem(stringArray[i]);
                    ((AbstractButton)object).setActionCommand("add");
                    ((AbstractButton)object).addActionListener(this);
                    jMenu.add((JMenuItem)object);
                }
            }
            jMenu.setEnabled(stringArray != null && stringArray.length > 0);
            Element element = xSDComponent.getElement();
            if (element.hasAttribute("ref") && (object = SchemaHelper.getAnyByName(element.getOwnerDocument().getDocumentElement(), element.getAttribute("ref"))) != null) {
                jMenuItem = new JMenuItem("Open Reference");
                jMenuItem.setActionCommand("openref");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
            }
            if (element.hasAttribute("type") && (object = SchemaHelper.getComplexTypeByName(element.getOwnerDocument().getDocumentElement(), element.getAttribute("type"))) != null) {
                jMenuItem = new JMenuItem("Open Type");
                jMenuItem.setActionCommand("opentype");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
            }
            object = new JMenuItem("Move up");
            ((AbstractButton)object).setActionCommand("moveup");
            ((AbstractButton)object).addActionListener(this);
            this.add((JMenuItem)object);
            if (SchemaHelper.isFirstElement(xSDComponent.getElement())) {
                ((JMenuItem)object).setEnabled(false);
            }
            jMenuItem = new JMenuItem("Move down");
            jMenuItem.setActionCommand("movedown");
            jMenuItem.addActionListener(this);
            this.add(jMenuItem);
            if (SchemaHelper.isLastElement(xSDComponent.getElement())) {
                jMenuItem.setEnabled(false);
            }
            JMenuItem jMenuItem2 = new JMenuItem("Open All");
            jMenuItem2.setActionCommand("openall");
            jMenuItem2.addActionListener(this);
            this.add(jMenuItem2);
            this.addSeparator();
            JMenuItem jMenuItem3 = new JMenuItem("Delete");
            jMenuItem3.setActionCommand("delete");
            jMenuItem3.addActionListener(this);
            this.add(jMenuItem3);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("delete".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.deleteXML(this.component);
            } else if ("add".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.addXMLChild(this.component, ((JMenuItem)actionEvent.getSource()).getText());
            } else if ("moveup".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.moveUp(this.component);
            } else if ("movedown".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.moveDown(this.component);
            } else if ("openref".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.openReference(this.component);
            } else if ("opentype".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.openType(this.component);
            } else if ("openall".equals(actionEvent.getActionCommand())) {
                DesignerViewImpl.this.openAll(this.component);
            }
            this.component = null;
        }
    }
}

