/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.xpath;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.dom.DocumentImpl;
import com.japisoft.fastparser.dom.DomNodeFactory;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ui.Toolkit;
import com.japisoft.framework.ui.toolkit.FileManager;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xquery.XQueryEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPathSyntaxException;
import org.jaxen.dom.DOMXPath;
import org.jdesktop.layout.GroupLayout;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XPathUI
extends JPanel
implements ActionListener,
ListSelectionListener,
MouseListener,
MouseMotionListener {
    private List currentResultList = null;
    private String currentFileLocation = null;
    private ButtonGroup bgVersion;
    private JButton btRunFromRoot;
    private JButton btRunFromCurrent;
    private JButton btCopy;
    private JLabel jLabel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JTabbedPane jTabbedPane1;
    private JPanel pnHistory;
    private JPanel pnNamespace;
    private JPanel pnResult;
    private JPanel pnVar;
    private JScrollPane spHistory;
    private JScrollPane spNamespace;
    private JScrollPane spResult;
    private JScrollPane spVar;
    private XQueryEditor taXPath;
    private JTable tbHistory;
    private JTable tbNamespace;
    private JTable tbResult;
    private JTable tbVar;
    private HistorySelection hs;

    XPathUI() {
        this.initComponents();
        this.tbHistory.getSelectionModel().setSelectionMode(2);
        this.tbNamespace.getSelectionModel().setSelectionMode(0);
        this.tbResult.getSelectionModel().setSelectionMode(0);
        this.tbVar.getSelectionModel().setSelectionMode(0);
        this.unshowSyntaxError();
        this.getActionMap().put("run-current", new RunFromCurrentAction());
        this.getActionMap().put("run-root", new RunFromRootAction());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "run-root");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 192), "run-current");
        this.taXPath.setDisplayRowHeader(false);
        Icon icon = Toolkit.getIconFromClasspath("images/gear_run.png");
        this.btRunFromCurrent.setIcon(icon);
        this.btRunFromRoot.setIcon(icon);
    }

    public void addNotify() {
        super.addNotify();
        this.btRunFromCurrent.addActionListener(this);
        this.btRunFromRoot.addActionListener(this);
        this.btCopy.addActionListener(this);
        this.tbResult.getSelectionModel().addListSelectionListener(this);
        this.hs = new HistorySelection();
        this.tbHistory.getSelectionModel().addListSelectionListener(this.hs);
        this.tbHistory.addMouseListener(this);
        this.tbHistory.addMouseMotionListener(this);
        this.tbResult.addMouseMotionListener(this);
        this.jRadioButton1.addActionListener(this);
        this.jRadioButton2.addActionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btRunFromCurrent.removeActionListener(this);
        this.btRunFromRoot.removeActionListener(this);
        this.btCopy.removeActionListener(this);
        this.tbResult.getSelectionModel().removeListSelectionListener(this);
        this.tbHistory.getSelectionModel().removeListSelectionListener(this.hs);
        this.tbHistory.removeMouseListener(this);
        this.tbHistory.removeMouseMotionListener(this);
        this.tbResult.removeMouseMotionListener(this);
        this.jRadioButton1.removeActionListener(this);
        this.jRadioButton2.removeActionListener(this);
    }

    private void initComponents() {
        this.bgVersion = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.taXPath = new XQueryEditor();
        this.btRunFromRoot = new JButton();
        this.btRunFromCurrent = new JButton();
        this.btCopy = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnResult = new JPanel();
        this.spResult = new JScrollPane();
        this.tbResult = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.pnVar = new JPanel();
        this.spVar = new JScrollPane();
        this.tbVar = new JTable();
        this.pnNamespace = new JPanel();
        this.spNamespace = new JScrollPane();
        this.tbNamespace = new JTable();
        this.pnHistory = new JPanel();
        this.spHistory = new JScrollPane();
        this.tbHistory = new JTable(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.jLabel1.setText("<html><body>XPath expression<br><font size='-2'>Use <b>Ctrl-enter</b> or <b>Ctrl-shift-enter</b><br>For running from root or current</font></body></html>");
        this.btRunFromRoot.setText("From root");
        this.btRunFromCurrent.setText("From current");
        this.btCopy.setText("Copy");
        this.bgVersion.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("1.0");
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.bgVersion.add(this.jRadioButton2);
        this.jRadioButton2.setText("2.0");
        this.jRadioButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.tbResult.setModel(new DefaultTableModel(new Object[]{"Node", "Value"}, 0));
        this.spResult.setViewportView(this.tbResult);
        GroupLayout groupLayout = new GroupLayout((Container)this.pnResult);
        this.pnResult.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.spResult, -1, 215, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.spResult, -1, 104, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Result", this.pnResult);
        this.tbVar.setModel(new DefaultTableModel(new Object[]{"Variable", "Value"}, 20));
        this.spVar.setViewportView(this.tbVar);
        GroupLayout groupLayout2 = new GroupLayout((Container)this.pnVar);
        this.pnVar.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spVar, -1, 215, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.spVar, -1, 104, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Variable", this.pnVar);
        this.tbNamespace.setModel(new DefaultTableModel(new Object[]{"Prefix", "Namespace"}, 20));
        this.spNamespace.setViewportView(this.tbNamespace);
        GroupLayout groupLayout3 = new GroupLayout((Container)this.pnNamespace);
        this.pnNamespace.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.spNamespace, -1, 215, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.spNamespace, -1, 104, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("Namespace", this.pnNamespace);
        this.tbHistory.setModel(new DefaultTableModel(new Object[]{"Last"}, 30));
        this.spHistory.setViewportView(this.tbHistory);
        GroupLayout groupLayout4 = new GroupLayout((Container)this.pnHistory);
        this.pnHistory.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.spHistory, -1, 215, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.spHistory, -1, 104, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("History", this.pnHistory);
        GroupLayout groupLayout5 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(2).add(1, (Component)this.jTabbedPane1, -1, 220, Short.MAX_VALUE).add(1, (Component)this.taXPath.getView(), -1, 220, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0, 80, Short.MAX_VALUE).add((Component)this.btCopy)).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.btRunFromRoot).addPreferredGap(0).add((Component)this.btRunFromCurrent)).add(1, (GroupLayout.Group)groupLayout5.createSequentialGroup().add((Component)this.jRadioButton1).add(14, 14, 14).add((Component)this.jRadioButton2))).addContainerGap()));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add((GroupLayout.Group)groupLayout5.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.btCopy)).addPreferredGap(0).add((Component)this.taXPath.getView(), -2, 90, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.btRunFromRoot).add((Component)this.btRunFromCurrent)).addPreferredGap(0).add((GroupLayout.Group)groupLayout5.createParallelGroup(3).add((Component)this.jRadioButton1).add((Component)this.jRadioButton2)).addPreferredGap(0).add((Component)this.jTabbedPane1, -1, 132, Short.MAX_VALUE).addContainerGap()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.jRadioButton1) {
            this.btRunFromCurrent.setEnabled(this.jRadioButton1.isSelected());
            this.jTabbedPane1.setEnabledAt(1, this.jRadioButton1.isSelected());
            this.jTabbedPane1.setEnabledAt(2, this.jRadioButton1.isSelected());
        } else if (actionEvent.getSource() == this.jRadioButton2) {
            this.btRunFromCurrent.setEnabled(this.jRadioButton1.isSelected());
            this.jTabbedPane1.setEnabledAt(1, this.jRadioButton1.isSelected());
            this.jTabbedPane1.setEnabledAt(2, this.jRadioButton1.isSelected());
        } else if (actionEvent.getSource() == this.btCopy) {
            this.copy();
        } else {
            this.currentResultList = null;
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.tbResult.getModel();
            while (defaultTableModel.getRowCount() > 0) {
                defaultTableModel.removeRow(0);
            }
            this.jTabbedPane1.setSelectedIndex(0);
            this.unshowSyntaxError();
            if (actionEvent.getSource() == this.btRunFromCurrent) {
                this.runFromCurrent();
            } else if (actionEvent.getSource() == this.btRunFromRoot) {
                this.runFromRoot();
            }
            if (defaultTableModel.getRowCount() > 0) {
                this.tbResult.getSelectionModel().setSelectionInterval(0, 0);
                this.tbResult.requestFocus();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.tbResult.getSelectedRow() == -1) {
            return;
        }
        if (this.currentResultList != null) {
            Object e = this.currentResultList.get(this.tbResult.getSelectedRow());
            if (this.currentFileLocation != null) {
                EditixFrame.ACCESSOR.activeXMLContainer(this.currentFileLocation);
            }
            if (e instanceof Node) {
                Node node = (Node)e;
                SimpleNode simpleNode = (SimpleNode)((Object)node);
                XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
                if (xMLContainer != null) {
                    xMLContainer.getEditor().highlightNode(simpleNode);
                    xMLContainer.getEditor().setCaretPosition(simpleNode.getStartingOffset() + 1);
                }
            } else if (e instanceof NodeInfo) {
                NodeInfo nodeInfo = (NodeInfo)e;
                XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
                if (xMLContainer != null) {
                    xMLContainer.getEditor().highlightNode(nodeInfo.getLineNumber());
                    xMLContainer.getEditor().setLineNumber(nodeInfo.getLineNumber());
                }
            }
        }
    }

    private void copy() {
        java.awt.Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("" + this.taXPath.getText()), null);
    }

    private void runFromCurrent() {
        try {
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
            if (xMLContainer == null) {
                xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            }
            if (xMLContainer == null) {
                throw new RuntimeException("No selected document. Open a document");
            }
            SimpleNode simpleNode = xMLContainer.getCurrentNode();
            if (simpleNode == null) {
                throw new RuntimeException("No selected node");
            }
            String string = simpleNode.getXPathLocation();
            SimpleNode simpleNode2 = (SimpleNode)((Object)this.getNodeFromRoot());
            simpleNode = simpleNode2.getNodeForXPathLocation(string, false);
            if (simpleNode == null) {
                simpleNode = simpleNode2;
            }
            if (this.jRadioButton2.isSelected()) {
                this.runForXPath2_0((Node)((Object)simpleNode));
            } else {
                this.runForXPath1_0((Node)((Object)simpleNode));
            }
        }
        catch (Throwable throwable) {
            this.processError(throwable);
        }
    }

    private void runFromRoot() {
        try {
            DocumentImpl documentImpl = new DocumentImpl((Element)this.getNodeFromRoot());
            if (this.jRadioButton2.isSelected()) {
                this.runForXPath2_0(documentImpl);
            } else {
                this.runForXPath1_0(documentImpl);
            }
        }
        catch (Throwable throwable) {
            this.processError(throwable);
        }
    }

    private void processError(Throwable throwable) {
        if (throwable instanceof XPathException) {
            XPathException xPathException = (XPathException)throwable;
            if (xPathException.getLocator() != null) {
                javax.swing.text.Element element = this.taXPath.getDocument().getDefaultRootElement().getElement(xPathException.getLocator().getLineNumber());
                this.showSyntaxError((element != null ? element.getStartOffset() : 0) + xPathException.getLocator().getColumnNumber(), xPathException.getMessage());
            } else {
                this.showSyntaxError(0, xPathException.getMessage());
            }
        } else if (throwable instanceof XPathSyntaxException) {
            this.showSyntaxError(((XPathSyntaxException)throwable).getPosition(), ((XPathSyntaxException)throwable).getMessage());
        } else {
            EditixFactory.buildAndShowErrorDialog(throwable.getMessage());
        }
    }

    private void runForXPath2_0(Node node) throws Throwable {
        Item item;
        ArrayList<Item> arrayList;
        Configuration configuration = new Configuration();
        configuration.setLineNumbering(true);
        configuration.setValidation(false);
        StaticQueryContext staticQueryContext = new StaticQueryContext(configuration);
        XQueryExpression xQueryExpression = staticQueryContext.compileQuery(this.taXPath.getText());
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(configuration);
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
        if (xMLContainer == null) {
            xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        }
        dynamicQueryContext.setContextNode((NodeInfo)staticQueryContext.buildDocument((Source)new StreamSource(new StringReader(xMLContainer.getAccessibility().getText()), xMLContainer.getCurrentDocumentLocation())));
        SequenceIterator sequenceIterator = xQueryExpression.iterator(dynamicQueryContext);
        this.currentResultList = arrayList = new ArrayList<Item>();
        while ((item = sequenceIterator.next()) != null) {
            arrayList.add(item);
        }
        this.showResult(arrayList);
    }

    private void runForXPath1_0(Node node) throws Throwable {
        Object object;
        DOMXPath dOMXPath = new DOMXPath(this.taXPath.getText());
        SimpleVariableContext simpleVariableContext = null;
        TableModel tableModel = this.tbVar.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string;
            object = (String)tableModel.getValueAt(i, 0);
            if (object == null || "".equals(object) || ((String)object).length() <= 0) continue;
            if (simpleVariableContext == null) {
                simpleVariableContext = new SimpleVariableContext();
                dOMXPath.setVariableContext(simpleVariableContext);
            }
            if ((string = (String)tableModel.getValueAt(i, 1)) == null) continue;
            simpleVariableContext.setVariableValue((String)object, string);
        }
        SimpleNamespaceContext simpleNamespaceContext = null;
        object = this.tbNamespace.getModel();
        for (int i = 0; i < object.getRowCount(); ++i) {
            String string;
            String string2 = (String)object.getValueAt(i, 0);
            if (string2 == null || "".equals(string2) || string2.length() <= 0 || (string = (String)object.getValueAt(i, 1)) == null) continue;
            if (simpleNamespaceContext == null) {
                simpleNamespaceContext = new SimpleNamespaceContext();
                dOMXPath.setNamespaceContext(simpleNamespaceContext);
            }
            simpleNamespaceContext.addNamespace(string2, string);
        }
        Object object2 = dOMXPath.evaluate(node);
        this.showResult(object2);
    }

    private void showResult(Object object) {
        if (object instanceof List) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.tbResult.getModel();
            List list = (List)object;
            this.currentResultList = (List)object;
            if (list.size() == 0) {
                EditixFactory.buildAndShowInformationDialog("No result");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    Object object2;
                    Object e = list.get(i);
                    if (e instanceof NodeInfo) {
                        object2 = (NodeInfo)e;
                        defaultTableModel.addRow(new Object[]{object2.getDisplayName(), object2.getStringValue()});
                        continue;
                    }
                    if (e instanceof Node) {
                        Node node;
                        Node node2;
                        object2 = ((Node)e).getNodeName();
                        String string = ((Node)e).getNodeValue();
                        if (string == null && (node2 = (Node)e).getFirstChild() != null && (node = node2.getFirstChild()) instanceof Text) {
                            string = ((Text)node).getNodeValue();
                        }
                        defaultTableModel.addRow(new Object[]{object2, string});
                        continue;
                    }
                    defaultTableModel.addRow(new Object[]{"[Not a node]", e});
                }
            }
        } else {
            EditixFactory.buildAndShowInformationDialog("Result = " + object);
        }
        this.addToHistory(this.taXPath.getText());
    }

    private void addToHistory(String string) {
        TableModel tableModel = this.tbHistory.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string2 = (String)tableModel.getValueAt(i, 0);
            if (!string.equals(string2)) continue;
            return;
        }
        this.tbHistory.getSelectionModel().removeListSelectionListener(this.hs);
        ((DefaultTableModel)this.tbHistory.getModel()).insertRow(0, new Object[]{this.taXPath.getText()});
        if (this.tbHistory.getModel().getRowCount() > 30) {
            ((DefaultTableModel)this.tbHistory.getModel()).removeRow(30);
        }
        this.tbHistory.getSelectionModel().addListSelectionListener(this.hs);
    }

    private Node getNodeFromRoot() throws Throwable {
        if (this.taXPath.getText() == null) {
            throw new RuntimeException("No expression found");
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedSubContainer("XML");
        if (xMLContainer == null) {
            xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        }
        if (xMLContainer == null) {
            throw new RuntimeException("No selected document. Open a document");
        }
        this.currentFileLocation = xMLContainer.getCurrentDocumentLocation();
        String string = xMLContainer.getText();
        Parser parser = new Parser();
        parser.setNodeFactory(new DomNodeFactory());
        parser.setReader(new StringReader(string));
        parser.parse();
        return (Node)((Object)parser.getDocument().getRoot());
    }

    private void unshowSyntaxError() {
        this.taXPath.getEditor().setCaretColor(Color.BLACK);
    }

    private void showSyntaxError(int n, String string) {
        this.taXPath.getEditor().setCaretPosition(n);
        this.taXPath.getEditor().setCaretColor(Color.red);
        EditixFactory.buildAndShowErrorDialog(string);
        this.taXPath.requestFocus();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() > 1) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ExportHistoryAction());
            jPopupMenu.add(new ImportHistoryAction());
            jPopupMenu.addSeparator();
            jPopupMenu.add(new CopyHistoryAction());
            jPopupMenu.addSeparator();
            jPopupMenu.add(new CleanCurrentHistoryAction());
            jPopupMenu.add(new CleanAllHistoryAction());
            jPopupMenu.show(this.tbHistory, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.tbHistory) {
            int n = this.tbHistory.rowAtPoint(mouseEvent.getPoint());
            if (n > -1) {
                String string = (String)this.tbHistory.getValueAt(n, 0);
                if (string == null) {
                    this.tbHistory.setToolTipText("No expression");
                } else {
                    this.tbHistory.setToolTipText(string);
                }
            }
        } else {
            int n = this.tbResult.rowAtPoint(mouseEvent.getPoint());
            if (n > -1) {
                String string = (String)this.tbResult.getValueAt(n, 0);
                String string2 = (String)this.tbResult.getValueAt(n, 1);
                StringBuffer stringBuffer = new StringBuffer("<html><body>");
                stringBuffer.append("<b>Name</b>");
                stringBuffer.append("<br>");
                stringBuffer.append(string);
                stringBuffer.append("<br>");
                stringBuffer.append("<b>Value</b><div style='width:200px'>");
                if (string2 == null) {
                    string2 = "<i>No value</i>";
                }
                stringBuffer.append(string2);
                stringBuffer.append("</div>");
                stringBuffer.append("</body></html>");
                this.tbResult.setToolTipText(stringBuffer.toString());
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    class CopyHistoryAction
    extends AbstractAction {
        public CopyHistoryAction() {
            this.putValue("Name", "Copy");
            this.putValue("ShortDescription", "Copy this expression to the clipboard");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = XPathUI.this.tbHistory.getSelectedRow();
            if (n > -1) {
                StringSelection stringSelection = new StringSelection((String)XPathUI.this.tbHistory.getModel().getValueAt(n, 0));
                Clipboard clipboard = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        }
    }

    class CleanCurrentHistoryAction
    extends AbstractAction {
        CleanCurrentHistoryAction() {
            this.putValue("Name", "Clean the selected expression(s)");
            this.putValue("ShortDescription", "Remove the selected expression(s)");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XPathUI.this.tbHistory.getSelectedRows();
            if (nArray != null && nArray.length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    ((DefaultTableModel)XPathUI.this.tbHistory.getModel()).removeRow(nArray[i]);
                }
            }
        }
    }

    class CleanAllHistoryAction
    extends AbstractAction {
        CleanAllHistoryAction() {
            this.putValue("Name", "Clean all");
            this.putValue("ShortDescription", "Remove all the expressions");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Last expressions"}, 30);
            XPathUI.this.tbHistory.setModel(defaultTableModel);
        }
    }

    class ImportHistoryAction
    extends AbstractAction {
        ImportHistoryAction() {
            this.putValue("Name", "Import");
            this.putValue("ShortDescription", "Import a TXT file with one expression by line. Lines with (: and :) are ignored");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileManager.getSelectedFile(true, "txt", "XPath list");
            if (file != null) {
                try {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    try {
                        String string = null;
                        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{"Last expressions"}, 0);
                        while ((string = bufferedReader.readLine()) != null) {
                            if (string.contains("(:") && string.contains(":)") || "".equals(string)) continue;
                            defaultTableModel.addRow(new Object[]{string.trim()});
                        }
                        XPathUI.this.tbHistory.setModel(defaultTableModel);
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class ExportHistoryAction
    extends AbstractAction {
        ExportHistoryAction() {
            this.putValue("Name", "Export");
            this.putValue("ShortDescription", "Export to a TXT file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileManager.getSelectedFile(false, "txt", "XPath list");
            if (file != null) {
                TableModel tableModel = XPathUI.this.tbHistory.getModel();
                try {
                    FileWriter fileWriter = new FileWriter(file);
                    BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                    try {
                        for (int i = 0; i < tableModel.getRowCount(); ++i) {
                            if (tableModel.getValueAt(i, 0) == null) continue;
                            if (i > 0) {
                                bufferedWriter.newLine();
                            }
                            bufferedWriter.write((String)tableModel.getValueAt(i, 0));
                        }
                    }
                    finally {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class HistorySelection
    implements ListSelectionListener {
        HistorySelection() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                XPathUI.this.taXPath.setText((String)XPathUI.this.tbHistory.getModel().getValueAt(XPathUI.this.tbHistory.getSelectedRow(), 0));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RunFromRootAction
    extends AbstractAction {
        RunFromRootAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XPathUI.this.btRunFromRoot.doClick();
        }
    }

    class RunFromCurrentAction
    extends AbstractAction {
        RunFromCurrentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XPathUI.this.btRunFromCurrent.doClick();
        }
    }
}

