/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.snippet;

import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.framework.ApplicationModel;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class SnippetTool {
    static SimpleNode currentRoot;

    static SimpleNode getRoot() throws IOException {
        if (currentRoot != null) {
            return currentRoot;
        }
        File file = new File(ApplicationModel.getAppUserPath(), "snippets.xml");
        if (!file.exists()) {
            return SnippetTool.getDefaultRoot();
        }
        return SnippetTool.getRoot(new FileReader(file));
    }

    private static SimpleNode getDefaultRoot() throws IOException {
        URL uRL = SnippetTool.class.getResource("snippets.xml");
        if (uRL == null) {
            SwingNode swingNode = new SwingNode(1, "group");
            swingNode.setAttribute("name", "snippets");
            currentRoot = swingNode;
            return swingNode;
        }
        return SnippetTool.getRoot(new InputStreamReader(uRL.openStream()));
    }

    private static SimpleNode getRoot(Reader reader) throws IOException {
        try {
            Parser parser = new Parser();
            parser.setNodeFactory(new SwingNodeFactory());
            parser.setReader(reader);
            parser.parse();
            Document document = parser.getDocument();
            currentRoot = (SimpleNode)document.getRoot();
            return currentRoot;
        }
        catch (ParseException parseException) {
            throw new IOException("Can't parse the snippets file : " + parseException.getMessage());
        }
    }

    public static void storeSnippetsFile() throws IOException {
        if (currentRoot == null) {
            return;
        }
        File file = new File(ApplicationModel.getAppUserPath(), "snippets.xml");
        Document document = currentRoot.getDocument();
        document.write(new FileWriter(file));
    }
}

