/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.application.descriptor.helpers.MenuBuilderDelegate;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.Encoding;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class TabSizeBuilder
implements MenuBuilderDelegate {
    public void build(JMenu jMenu) {
        jMenu.setEnabled(true);
        String[] stringArray = Encoding.XML_ENCODINGS;
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = Preferences.getPreference("file", "tab-size", 4);
        for (int i = 1; i < 8; ++i) {
            ChangeTabSizeAction changeTabSizeAction = new ChangeTabSizeAction(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(changeTabSizeAction);
            if (i == n) {
                jRadioButtonMenuItem.setSelected(true);
            }
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
    }

    class ChangeTabSizeAction
    extends AbstractAction {
        int size;

        ChangeTabSizeAction(int n) {
            this.size = n;
            this.putValue("Name", "" + n + " whitespace" + (n > 1 ? "s" : ""));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Preferences.setPreference("file", "tab-size", this.size);
            EditixFactory.buildAndShowInformationDialog("Please restart EditiX for applying");
        }
    }
}

