/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.toolkit;

import com.japisoft.editix.ui.EditixStatusBar;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.Encoding;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;

public class Toolkit {
    static String[] FILE_ENCODING = Encoding.XML_ENCODINGS;

    public static String getCurrentFileEncoding() {
        String[] stringArray = Preferences.getPreference("file", "rw-encoding", FILE_ENCODING);
        return stringArray[0];
    }

    public static Reader getReaderForFile(File file) throws IOException {
        String string = Toolkit.getCurrentFileEncoding();
        InputStreamReader inputStreamReader = "DEFAULT".equals(string) || "AUTOMATIC".equals(string) ? new FileReader(file) : new InputStreamReader((InputStream)new FileInputStream(file), string);
        return inputStreamReader;
    }

    public static Reader getReaderForFile(String string) throws IOException {
        return Toolkit.getReaderForFile(new File(string));
    }

    public static Writer getWriterForFile(File file) throws IOException {
        String string = Toolkit.getCurrentFileEncoding();
        OutputStreamWriter outputStreamWriter = null;
        outputStreamWriter = "DEFAULT".equals(string) ? new FileWriter(file) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), string);
        return outputStreamWriter;
    }

    public static XMLFileData getEncodedString(byte[] byArray) throws Throwable {
        String string = Toolkit.getCurrentFileEncoding();
        XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(new ByteArrayInputStream(byArray), Toolkit.getCurrentFileEncoding());
        return xMLFileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromInputStream(InputStream inputStream) throws Throwable {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        try {
            int n;
            InputStreamReader inputStreamReader = null;
            String string = Toolkit.getCurrentFileEncoding();
            inputStreamReader = "DEFAULT".equals(string) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuffer.append(new String(cArray, 0, n));
            }
        }
        finally {
            inputStream.close();
        }
        return stringBuffer.toString();
    }

    public static String getPathForObject(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL == null) {
            return null;
        }
        if (uRL.getProtocol().equals("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                uRL = jarURLConnection.getJarFileURL();
                String string2 = uRL.toExternalForm();
                string2 = string2.replaceAll("%20", " ");
                if (string2.startsWith("file://")) {
                    return string2.substring(6);
                }
                if (string2.startsWith("file:/")) {
                    return string2.substring(5);
                }
                return string2;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return uRL.toExternalForm();
    }

    public static String toURL(File file) throws MalformedURLException {
        String string = file.toURI().toURL().toString();
        string = string.replace(" ", "%20");
        return string;
    }

    public static void startJob(String string, Runnable runnable) {
        EditixStatusBar.ACCESSOR.setMessage(string);
        SwingUtilities.invokeLater(runnable);
    }

    public static void stopJob() {
        EditixStatusBar.ACCESSOR.setXPathLocation("Completed");
    }
}

