/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.berkley;

import com.japisoft.editix.db.NodeDb;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.editix.db.berkley.BerkleyContainerDbImpl;
import com.japisoft.editix.db.berkley.BerkleyFileNodeImpl;
import com.japisoft.editix.ui.EditixFactory;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlManager;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlQueryExpression;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlValue;
import java.util.ArrayList;

public class BerkleyRootDbImpl
extends BerkleyContainerDbImpl
implements RootNodeDb {
    private XmlManager m;

    public BerkleyRootDbImpl(String string, String string2) throws Exception {
        super(null);
        this.driverName = string;
        this.url = string2;
    }

    public NodeDb[] request(String string) throws Exception {
        NodeDb[] nodeDbArray = null;
        XmlQueryContext xmlQueryContext = this.m.createQueryContext();
        XmlQueryExpression xmlQueryExpression = this.m.prepare(string, xmlQueryContext);
        XmlResults xmlResults = xmlQueryExpression.execute(xmlQueryContext);
        if (xmlResults != null) {
            ArrayList<BerkleyRootDbImpl> arrayList = new ArrayList<BerkleyRootDbImpl>();
            BerkleyRootDbImpl berkleyRootDbImpl = new BerkleyRootDbImpl(this.driverName, this.url);
            berkleyRootDbImpl.m = this.m;
            berkleyRootDbImpl.container = this.container;
            while (xmlResults.hasNext()) {
                XmlValue xmlValue = xmlResults.next();
                if (xmlValue.isNode()) {
                    XmlDocument xmlDocument = xmlValue.asDocument();
                    xmlDocument = this.container.getDocument(xmlDocument.getName());
                    berkleyRootDbImpl.addChild(new BerkleyFileNodeImpl(xmlDocument));
                    arrayList.add(berkleyRootDbImpl);
                    continue;
                }
                EditixFactory.buildAndShowInformationDialog(xmlValue.asString());
            }
            nodeDbArray = new NodeDb[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nodeDbArray[i] = (NodeDb)arrayList.get(i);
            }
        }
        xmlQueryExpression.delete();
        xmlQueryContext.delete();
        return nodeDbArray;
    }

    public boolean canConnect() {
        return this.container != null;
    }

    public void open() throws Exception {
        if (this.m == null) {
            this.m = new XmlManager();
        }
        this.container = this.m.openContainer(this.url);
        int n = this.url.lastIndexOf("/");
        if (n == -1) {
            n = this.url.lastIndexOf("\\");
        }
        String string = this.url.substring(n + 1);
        this.container.addAlias(string);
        int n2 = string.lastIndexOf(".");
        if (n2 > -1) {
            this.container.addAlias(string.substring(0, n2));
        }
        super.open();
    }

    public void close() {
        super.close();
    }

    protected void prepareName() {
        int n = this.url.lastIndexOf("/");
        if (n == -1) {
            n = this.url.lastIndexOf("\\");
        }
        this.name = "berkley-" + this.url.substring(n + 1);
    }

    public String toXml() {
        return "<connection driver='" + this.driverName + "' url='" + this.url + "' embedded='true'/>";
    }
}

