/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.db.RootNodeDb;
import com.japisoft.fastparser.node.SimpleNode;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class Driver {
    protected String name;
    public String url;
    public String jars;
    public String dbxmlClass;
    public boolean canAddContainer = false;
    public boolean canRemoveContainer = false;
    public boolean query = false;
    public boolean embedded = false;
    public boolean system = false;
    private boolean install = false;

    public Driver(String string) {
        this.name = string;
    }

    public Driver(SimpleNode simpleNode) {
        this.name = simpleNode.getAttribute("name");
        this.url = simpleNode.getAttribute("url");
        this.jars = simpleNode.getAttribute("jars");
        this.system = "true".equals(simpleNode.getAttribute("system"));
        this.dbxmlClass = simpleNode.getAttribute("xmldbDriver");
        String string = System.getProperty("user.home");
        string = string.replace('\\', '/');
        this.url = this.url.replaceFirst("\\$H", string);
        this.embedded = "true".equals(simpleNode.getAttribute("embedded", "false"));
        this.canAddContainer = "true".equals(simpleNode.getAttribute("addc", "false"));
        this.canRemoveContainer = "true".equals(simpleNode.getAttribute("removec", "true"));
        this.query = "true".equals(simpleNode.getAttribute("query", "false"));
    }

    public void install() {
        if (!this.install) {
            this.install = true;
            if (this.jars != null) {
                String[] stringArray = this.jars.split(";");
                URL[] uRLArray = new URL[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    File file = new File(stringArray[i]);
                    try {
                        if (file.exists()) {
                            uRLArray[i] = file.toURI().toURL();
                            continue;
                        }
                        uRLArray[i] = new URL(stringArray[i]);
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        EditixApplicationModel.debug(malformedURLException);
                    }
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                this.install(uRLClassLoader);
            } else {
                this.install(ClassLoader.getSystemClassLoader());
            }
        }
    }

    protected void install(ClassLoader classLoader) {
    }

    public boolean test(String string, String string2, String string3) {
        this.install();
        return false;
    }

    public String toString() {
        return this.name;
    }

    public abstract RootNodeDb getRoot(String var1, String var2, String var3) throws Exception;

    public String toXml() {
        String string = "<driver system='" + this.system + "' name='" + this.name + "' class='" + this.getClass().getName() + "' url='" + this.url + "' xmldbDriver='" + this.dbxmlClass + "'";
        if (this.jars != null) {
            string = string + " jars='" + this.jars + "'";
        }
        string = string + " addc='" + this.canAddContainer + "' removec='" + this.canRemoveContainer + "' query='" + this.query + "'/>";
        return string;
    }
}

