/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.search.file;

import com.japisoft.editix.EditixApplicationModel;
import com.japisoft.editix.action.search.file.SearchEngine;
import com.japisoft.editix.action.search.file.SearchManager;
import com.japisoft.editix.action.search.file.SearchResult;
import com.japisoft.editix.action.search.file.SearchResultImpl;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.jdesktop.layout.GroupLayout;

public class FileSearchUI
extends JPanel
implements ActionListener,
TreeSelectionListener,
ItemListener {
    private File directory = null;
    private JButton btChooseDirectory;
    private JButton btSearch;
    private JComboBox cbContaining;
    private JComboBox cbFilter;
    private JCheckBox cbSave;
    private JComboBox cbSearchingIn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JProgressBar pbTime;
    private JTree treeResult;
    private JTextField txtWith;

    public FileSearchUI() {
        SearchManager.install();
        this.initComponents();
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.btSearch.addActionListener(this);
        this.btChooseDirectory.addActionListener(this);
        this.treeResult.addTreeSelectionListener(this);
        this.txtWith.addActionListener(this);
        this.cbSearchingIn.addItemListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btSearch.removeActionListener(this);
        this.btChooseDirectory.removeActionListener(this);
        this.treeResult.removeTreeSelectionListener(this);
        this.txtWith.removeActionListener(this);
        this.cbSearchingIn.removeItemListener(this);
    }

    private void init() {
        this.cbSearchingIn.addItem("Directory");
        this.cbSearchingIn.addItem("Project");
        this.cbSearchingIn.setSelectedIndex(0);
        for (int i = 0; i < SearchManager.getSearchEngineCount(); ++i) {
            this.cbContaining.addItem(SearchManager.getSearchEngineAt(i));
        }
        this.cbContaining.setSelectedIndex(0);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode("No result"));
        this.treeResult.setModel(defaultTreeModel);
        this.cbFilter.addItem("Any");
        EditixFactory.fillComboBoxFilter(this.cbFilter);
        this.cbFilter.setSelectedIndex(0);
        this.treeResult.setCellRenderer(new FileSearchRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readParameters(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string;
                int n = Integer.parseInt(bufferedReader.readLine());
                if (n > -1) {
                    this.cbContaining.setSelectedIndex(n);
                }
                if ((n = Integer.parseInt(bufferedReader.readLine())) > -1) {
                    this.cbSearchingIn.setSelectedIndex(n);
                }
                if ((n = Integer.parseInt(bufferedReader.readLine())) > -1) {
                    this.cbFilter.setSelectedIndex(n);
                }
                if (!"".equals(string = bufferedReader.readLine())) {
                    this.directory = new File(string);
                }
                this.txtWith.setText(bufferedReader.readLine());
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (Throwable throwable) {
            EditixApplicationModel.debug(throwable);
        }
    }

    boolean mustSave() {
        return this.cbSave.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveParameters(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write("" + this.cbContaining.getSelectedIndex());
                bufferedWriter.newLine();
                bufferedWriter.write("" + this.cbSearchingIn.getSelectedIndex());
                bufferedWriter.newLine();
                bufferedWriter.write("" + this.cbFilter.getSelectedIndex());
                bufferedWriter.newLine();
                if (this.directory != null) {
                    bufferedWriter.write(this.directory.toString());
                }
                bufferedWriter.newLine();
                bufferedWriter.write(this.txtWith.getText());
                bufferedWriter.newLine();
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            EditixApplicationModel.debug(iOException);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btSearch || actionEvent.getSource() == this.txtWith) {
            if ("".equals(this.txtWith.getText())) {
                this.txtWith.requestFocus();
            } else {
                if (this.cbSearchingIn.getSelectedIndex() == 0 && this.directory == null) {
                    this.chooseDirectory();
                }
                this.search();
            }
        } else if (actionEvent.getSource() != this.cbSearchingIn && actionEvent.getSource() == this.btChooseDirectory) {
            this.chooseDirectory();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.btChooseDirectory.setEnabled(this.cbSearchingIn.getSelectedIndex() <= 0);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.treeResult.getSelectionPath() == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeResult.getSelectionPath().getLastPathComponent();
        if (defaultMutableTreeNode.getUserObject() instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)defaultMutableTreeNode.getUserObject();
            File file = searchResult.getSource();
            if (file == null) {
                file = ((SearchResult)((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).getUserObject()).getSource();
            }
            if (EditixFrame.ACCESSOR.activeXMLContainerOrOpenIt(file.toString())) {
                XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
                int n = searchResult.getLine();
                if (defaultMutableTreeNode.getChildCount() > 0) {
                    n = ((SearchResult)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(0)).getUserObject()).getLine();
                }
                xMLContainer.getEditor().highlightLine(n + 1);
            }
        }
    }

    private void chooseDirectory() {
        JFileChooser jFileChooser = new JFileChooser();
        if (this.directory != null) {
            jFileChooser.setCurrentDirectory(this.directory);
        }
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Search in ?");
        if (jFileChooser.showOpenDialog(EditixFrame.ACCESSOR) == 0) {
            this.directory = jFileChooser.getSelectedFile();
        }
    }

    private void search() {
        this.btSearch.setEnabled(false);
        WorkingThread workingThread = new WorkingThread();
        workingThread.start();
    }

    private ArrayList getFilesToSearch() {
        File file;
        int n;
        Object object;
        ArrayList<File> arrayList = null;
        if (this.cbSearchingIn.getSelectedIndex() == 1) {
            arrayList = ProjectManager.getAllFiles();
        } else {
            File file2 = this.directory;
            if (file2 != null && (object = file2.list()) != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                for (n = 0; n < ((String[])object).length; ++n) {
                    file = new File(file2, object[n]);
                    if (!file.isFile()) continue;
                    arrayList.add(file);
                }
            }
        }
        if (arrayList != null) {
            boolean bl = this.cbFilter.getSelectedIndex() <= 0;
            object = null;
            if (!bl) {
                object = (EditixFactory.XMLDocumentInfoFileFilter)this.cbFilter.getSelectedItem();
            }
            n = 0;
            while (n < arrayList.size()) {
                file = (File)arrayList.get(n);
                if (!bl && !((EditixFactory.XMLDocumentInfoFileFilter)object).accept(file)) {
                    arrayList.remove(file);
                    continue;
                }
                ++n;
            }
        }
        return arrayList;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbContaining = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cbSearchingIn = new JComboBox();
        this.txtWith = new JTextField();
        this.jLabel3 = new JLabel();
        this.cbFilter = new JComboBox();
        this.jLabel4 = new JLabel();
        this.btSearch = new JButton();
        this.cbSave = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.treeResult = new JTree();
        this.btChooseDirectory = new JButton();
        this.pbTime = new JProgressBar();
        this.setBorder(BorderFactory.createTitledBorder("File Search"));
        this.jLabel1.setText("Matching this");
        this.cbContaining.setToolTipText("Type of research");
        this.jLabel2.setText("Searching in");
        this.cbSearchingIn.setToolTipText("File location");
        this.txtWith.setToolTipText("Item to search");
        this.jLabel3.setText("Filter");
        this.cbFilter.setToolTipText("Filter a document type");
        this.jLabel4.setText("With");
        this.btSearch.setText("Search");
        this.cbSave.setText("Save parameters");
        this.cbSave.setToolTipText("Save this parameters for the next editix usage");
        this.cbSave.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSave.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Result"));
        this.jScrollPane1.setViewportView(this.treeResult);
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 234, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 238, Short.MAX_VALUE));
        this.btChooseDirectory.setText("...");
        this.btChooseDirectory.setToolTipText("Directory chooser activator");
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 250, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.btSearch)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.cbFilter, 0, 179, Short.MAX_VALUE).add((Component)this.txtWith, -1, 179, Short.MAX_VALUE).add(1, (Component)this.cbContaining, 0, 179, Short.MAX_VALUE).add((Component)this.cbSave).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.cbSearchingIn, 0, 130, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btChooseDirectory, -2, 43, -2)))).add((Component)this.pbTime, -1, 250, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.cbContaining, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cbSearchingIn, -2, -1, -2).add((Component)this.btChooseDirectory)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.txtWith, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.cbFilter, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.btSearch).add((Component)this.cbSave)).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pbTime, -2, -1, -2)));
        groupLayout2.linkSize(new Component[]{this.btChooseDirectory, this.cbSearchingIn}, 2);
    }

    class FileSearchRenderer
    implements TreeCellRenderer {
        FastLabel fastlabel = new FastLabel(false);
        Icon drive = null;
        Icon item = null;

        public FileSearchRenderer() {
            try {
                this.drive = new ImageIcon(ClassLoader.getSystemResource("images/diskdrive.png"));
                this.item = new ImageIcon(ClassLoader.getSystemResource("images/bookmark.png"));
            }
            catch (Throwable throwable) {
                System.err.println("Can't init icons ? : " + throwable.getMessage());
            }
            this.fastlabel.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            if (!((object = defaultMutableTreeNode.getUserObject()) instanceof SearchResult)) {
                this.fastlabel.setText(object.toString());
                this.fastlabel.setIcon(this.drive);
            } else {
                object2 = (SearchResult)object;
                if (object2.getSource() != null) {
                    this.fastlabel.setText(object.toString());
                    this.fastlabel.setIcon(DocumentModel.getDocumentForExt(object2.getType()).getDocumentIcon());
                } else {
                    this.fastlabel.setIcon(this.item);
                    this.fastlabel.setText(object.toString());
                }
            }
            if (bl) {
                this.fastlabel.setForeground(UIManager.getColor("List.selectionForeground"));
                this.fastlabel.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                object2 = FileSearchUI.this.treeResult.getForeground();
                Color color = FileSearchUI.this.treeResult.getBackground();
                this.fastlabel.setForeground((Color)object2);
                this.fastlabel.setBackground(color);
            }
            return this.fastlabel;
        }
    }

    class WorkingThread
    extends Thread {
        WorkingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.doIt();
            }
            finally {
                FileSearchUI.this.btSearch.setEnabled(true);
                FileSearchUI.this.pbTime.setValue(0);
            }
        }

        private void doIt() {
            SearchEngine searchEngine = (SearchEngine)FileSearchUI.this.cbContaining.getSelectedItem();
            ArrayList arrayList = FileSearchUI.this.getFilesToSearch();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Result");
            if (arrayList != null) {
                FileSearchUI.this.pbTime.setMaximum(arrayList.size() - 1);
                block0: for (int i = 0; i < arrayList.size(); ++i) {
                    FileSearchUI.this.pbTime.setValue(i);
                    File file = (File)arrayList.get(i);
                    List list = searchEngine.search(file, FileSearchUI.this.txtWith.getText());
                    if (list == null || list.size() <= 0) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new SearchResultImpl(file, list.size()));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    for (int j = 0; j < list.size(); ++j) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(list.get(j));
                        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                        if (j > 100) continue block0;
                    }
                }
            }
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)FileSearchUI.this.treeResult.getModel();
            defaultMutableTreeNode.setUserObject(defaultMutableTreeNode.getChildCount() + " result(s)");
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
    }
}

