/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.action.file.OpenProjectAction;
import com.japisoft.editix.project.ProjectManager;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.NodeFactoryImpl;
import com.japisoft.fastparser.node.SimpleNode;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class NewProjectAction
extends AbstractAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = EditixFactory.buildProjectFileChooser();
        jFileChooser.setDialogTitle("Choose a new project file");
        if (jFileChooser.showSaveDialog(EditixFrame.ACCESSOR.getComponent(0)) == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.toString();
            if (string.indexOf(".") == -1) {
                string = string + ".pre";
            }
            if ((file = new File(string)).exists() && !EditixFactory.buildAndShowConfirmDialog("Overwrite this file " + file + " ?")) {
                return;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                try {
                    Document document = new Document();
                    document.setNodeFactory(new NodeFactoryImpl());
                    SimpleNode simpleNode = (SimpleNode)document.getNodeFactory().getTagNode("MyProject");
                    simpleNode.setAttribute("path", file.toString());
                    document.setRoot(simpleNode);
                    document.write(bufferedWriter);
                }
                finally {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                OpenProjectAction.updateOpenRecent(ProjectManager.getLastOpenProject(false));
                OpenProjectAction.openProject(true, file.toString());
            }
            catch (IOException iOException) {
                EditixFactory.buildAndShowErrorDialog("Error found : " + iOException.getMessage());
            }
        }
    }
}

