/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.file;

import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.document.TemplateInfo;
import com.japisoft.editix.template.NewTemplateDialog;
import com.japisoft.editix.toolkit.Toolkit;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.InformationDialog;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.action.ActionModel;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JLabel;

public class NewAction
extends AbstractAction {
    public static void prepare(TemplateInfo templateInfo) {
        if (templateInfo.encoding == null) {
            templateInfo.encoding = Preferences.getPreference("file", "rw-encoding", com.japisoft.framework.app.toolkit.Toolkit.FILE_ENCODING)[0];
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TemplateInfo templateInfo = this.getDocumentInfo();
        if (templateInfo == null) {
            return;
        }
        NewAction.prepare(templateInfo);
        NewAction.signalToUser(templateInfo.type);
        XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(templateInfo.type);
        IXMLPanel iXMLPanel = EditixFactory.getPanelForDocument(xMLDocumentInfo);
        XMLContainer xMLContainer = iXMLPanel.getMainContainer();
        XMLDocumentInfo xMLDocumentInfo2 = xMLDocumentInfo.cloneDocument();
        if (templateInfo.location != null) {
            try {
                this.loadTemplate(templateInfo.encoding, templateInfo.location, xMLDocumentInfo2);
            }
            catch (Throwable throwable) {
                EditixFactory.buildAndShowErrorDialog("Can't load " + templateInfo.location);
                throwable.printStackTrace();
                return;
            }
        }
        xMLContainer.setDocumentInfo(xMLDocumentInfo2);
        ActionModel.activeActionByName(ActionModel.NEW_ACTION, xMLContainer, xMLContainer.getEditor());
        xMLContainer.setProperty("encoding", Toolkit.getCurrentFileEncoding());
        EditixFrame.ACCESSOR.addContainer(iXMLPanel);
    }

    static void signalToUser(String string) {
        if ("EXML".equals(string) && Preferences.getPreference("system", "usertype" + string, true)) {
            InformationDialog informationDialog = new InformationDialog(new JLabel("Note that you are using a special editing mode for Large XML documents. Choose another document type for common documents", 2), "usertype" + string);
            ((Dialog)informationDialog).setVisible(true);
            informationDialog.dispose();
        }
    }

    private void loadTemplate(String string, String string2, XMLDocumentInfo xMLDocumentInfo) throws Throwable {
        File file = new File(string2);
        InputStream inputStream = null;
        if (file.exists()) {
            inputStream = new FileInputStream(file);
        } else {
            inputStream = ClassLoader.getSystemResourceAsStream(string2);
            if (inputStream == null) {
                URL uRL = new URL(string2);
                inputStream = uRL.openStream();
            }
        }
        xMLDocumentInfo.setTemplate(XMLToolkit.getContentFromInputStream(inputStream, string).getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateInfo getDocumentInfo() {
        if (this.getValue("template") != null) {
            return (TemplateInfo)this.getValue("template");
        }
        NewTemplateDialog newTemplateDialog = new NewTemplateDialog();
        newTemplateDialog.setVisible(true);
        try {
            if (newTemplateDialog.isOk()) {
                TemplateInfo templateInfo = newTemplateDialog.getTemplateInfo();
                return templateInfo;
            }
            TemplateInfo templateInfo = null;
            return templateInfo;
        }
        finally {
            newTemplateDialog.dispose();
        }
    }
}

