/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import DTDDoc.DTDCommenter;
import DTDDoc.ExtendedDTD;
import com.japisoft.editix.action.dtdschema.GenerateSchemaDoc;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.ui.toolkit.FileManager;
import com.japisoft.p.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractAction;

public class GenerateDTDDoc
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer.getCurrentDocumentLocation() == null) {
            EditixFactory.buildAndShowErrorDialog("Please save your DTD before");
            return;
        }
        File file = FileManager.getSelectedFile(false, "html", "HTML output file");
        if (file != null) {
            try {
                ExtendedDTD extendedDTD = new ExtendedDTD(new File(xMLContainer.getCurrentDocumentLocation()));
                String string = GenerateSchemaDoc.getCommonHeader(xMLContainer);
                String string2 = GenerateSchemaDoc.getCommonFooter(xMLContainer);
                DTDCommenter dTDCommenter = new DTDCommenter(string, string2);
                dTDCommenter.createDocumentation(extendedDTD, new PrintWriter(new FileWriter(file)), true);
                BrowserCaller.displayURL(file.toString());
            }
            catch (IOException iOException) {
                EditixFactory.buildAndShowErrorDialog("Can't create documentation : " + iOException.getMessage());
            }
        }
    }
}

