/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.action.dtdschema.MetaModelUpdatePanel;
import com.japisoft.editix.action.dtdschema.generator.MetaNode;
import com.japisoft.editix.action.dtdschema.generator.SchemaGenerator;
import com.japisoft.editix.action.dtdschema.generator.Transformer;
import com.japisoft.editix.document.DocumentModel;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.dialog.DialogManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.p.Manager;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.editor.XMLTemplate;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public abstract class GenerateAction
extends AbstractAction {
    private Transformer transformer;
    protected boolean formatResult = false;

    public GenerateAction(Transformer transformer) {
        this.transformer = transformer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Manager.isFree()) {
            EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
            BrowserCaller.displayURL("http://www.editix.com");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        SimpleNode simpleNode = (SimpleNode)xMLContainer.getTree().getModel().getRoot();
        if (simpleNode == null) {
            JOptionPane.showMessageDialog(xMLContainer.getView(), "Can't generate a schema for this document ");
            return;
        }
        MetaNode metaNode = SchemaGenerator.getMetaModel(simpleNode);
        if (DialogManager.showDialog(EditixFrame.ACCESSOR, "Meta model", "Your document content", "Check if EditiX has found the best attribute type by selecting each node and change it if needed, then press OK", null, new MetaModelUpdatePanel(metaNode)) == DialogManager.OK_ID) {
            String string = SchemaGenerator.generate(metaNode, this.transformer);
            XMLDocumentInfo xMLDocumentInfo = DocumentModel.getDocumentForType(this.transformer.getType());
            IXMLPanel iXMLPanel = EditixFactory.getPanelForDocument(xMLDocumentInfo);
            XMLContainer xMLContainer2 = iXMLPanel.getMainContainer();
            xMLContainer2.setAutoNewDocument(false);
            xMLContainer2.setDocumentInfo(xMLDocumentInfo);
            XMLTemplate xMLTemplate = new XMLTemplate();
            xMLTemplate.setRawContent((this.transformer.hasVersion() ? "<?xml version=\"1.0\" encoding=\"${default-encoding}\"?>\n" : "") + string);
            xMLContainer2.setText(xMLTemplate.toString(xMLDocumentInfo));
            EditixFrame.ACCESSOR.addContainer(iXMLPanel);
            if (this.formatResult) {
                ActionModel.activeActionById("format", null);
            }
        }
    }
}

