/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.editix.action.xml.UseDefaultDialog;
import com.japisoft.editix.action.xml.UseDefaultRootBuilder;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.pathbuilder.XSDPathBuilder;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.framework.xml.xsd.instance.XSDInstanceGenerator;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;

public class AssignSchema
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        XMLDocument xMLDocument = xMLContainer.getDocument();
        boolean bl = xMLDocument.parseSchema();
        Point point = null;
        if (bl) {
            point = xMLDocument.getLastDTDLocation();
        }
        String string = xMLContainer.getSchemaAccessibility().getCurrentSchemaRoot();
        String string2 = xMLContainer.getSchemaAccessibility().getCurrentSchema();
        if (string == null && xMLContainer.getTree().getModel().getRoot() != null) {
            string = ((SimpleNode)xMLContainer.getTree().getModel().getRoot()).getContent();
        }
        UseDefaultDialog useDefaultDialog = new UseDefaultDialog("Schema", "Add a Schema declaration to the current document location", "Schema", "xsd", new XSDPathBuilder());
        String string3 = Preferences.getPreference("file", "defaultSchemaPath", "");
        useDefaultDialog.setDefaultDirectoryForLocation(string3);
        useDefaultDialog.setRoot(string);
        useDefaultDialog.setXMLFileLocation(xMLContainer.getCurrentDocumentLocation());
        DelegateForRoots delegateForRoots = new DelegateForRoots();
        useDefaultDialog.setDelegateForRoots(delegateForRoots);
        useDefaultDialog.setVisible(true);
        if (!useDefaultDialog.isOk()) {
            return;
        }
        if (useDefaultDialog.getRoot() == null) {
            EditixFactory.buildAndShowErrorDialog("You must choose a root element");
            return;
        }
        if (useDefaultDialog.toURILocation() == null) {
            EditixFactory.buildAndShowErrorDialog("You must choose a Schema location");
            return;
        }
        string3 = useDefaultDialog.getDefaultDirectoryForLocation();
        if (string3 != null) {
            Preferences.setPreference("file", "defaultSchemaPath", string3);
        }
        if (xMLContainer.getRootNode() == null) {
            try {
                String string4 = XSDInstanceGenerator.generateXMLInstance(useDefaultDialog.getRoot(), useDefaultDialog.toURILocation());
                try {
                    xMLDocument.insertString(xMLContainer.getEditor().getCaretPosition(), string4, null);
                    xMLDocument.parseSchema();
                    ActionModel.activeActionById("format", null);
                }
                catch (BadLocationException badLocationException) {
                }
            }
            catch (Throwable throwable) {
                ApplicationModel.debug(throwable);
                EditixFactory.buildAndShowErrorDialog("Can't generate the XML instance : " + throwable.getMessage());
            }
        } else {
            SimpleNode simpleNode = xMLContainer.getRootNode();
            simpleNode.removeNameSpaceDeclaration("xsi");
            simpleNode.addNameSpaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            simpleNode.setAttribute("xsi:noNamespaceSchemaLocation", null);
            simpleNode.setAttribute("xsi:schemaLocation", null);
            if (simpleNode.getNameSpaceURI() == null) {
                simpleNode.setAttribute("xsi:noNamespaceSchemaLocation", useDefaultDialog.toURILocation());
            } else {
                simpleNode.setAttribute("xsi:schemaLocation", simpleNode.getNameSpaceURI() + " " + useDefaultDialog.toURILocation());
            }
            xMLDocument.updateNodeOpeningClosing(simpleNode);
            xMLDocument.parseSchema();
        }
    }

    class DelegateForRoots
    implements UseDefaultRootBuilder {
        private String targetNamespace = null;

        DelegateForRoots() {
        }

        public String[] getRoots(String string) {
            try {
                XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, null);
                Parser parser = new Parser();
                parser.setText(xMLFileData.getContent());
                parser.parse();
                Document document = parser.getDocument();
                SimpleNode simpleNode = (SimpleNode)document.getRoot();
                if (simpleNode != null) {
                    this.targetNamespace = simpleNode.getAttribute("targetNamespace");
                    ArrayList<String> arrayList = null;
                    for (int i = 0; i < simpleNode.getViewChildCount(); ++i) {
                        SimpleNode simpleNode2 = (SimpleNode)simpleNode.getViewChildAt(i);
                        if (!simpleNode2.matchContent("element")) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(simpleNode2.getAttribute("name"));
                    }
                    String[] stringArray = new String[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        stringArray[i] = (String)arrayList.get(i);
                    }
                    return stringArray;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

