/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.dtdschema;

import com.japisoft.dtdparser.DTDParser;
import com.japisoft.dtdparser.node.DTDNode;
import com.japisoft.dtdparser.node.ElementDTDNode;
import com.japisoft.dtdparser.node.RootDTDNode;
import com.japisoft.editix.action.xml.UseDefaultDialog;
import com.japisoft.editix.action.xml.UseDefaultRootBuilder;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.pathbuilder.DTDPathBuilder;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.dtd.instance.DTDInstanceGenerator;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;

public class AssignDTD
extends AbstractAction {
    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            return;
        }
        XMLDocument xMLDocument = (XMLDocument)xMLContainer.getEditor().getDocument();
        boolean bl = xMLDocument.parseDTD();
        Point point = null;
        if (bl) {
            point = xMLDocument.getLastDTDLocation();
        }
        String string = xMLContainer.getSchemaAccessibility().getCurrentDTDRoot();
        String string2 = xMLContainer.getSchemaAccessibility().getCurrentDTD();
        if (string == null && xMLContainer.getTree().getModel().getRoot() != null) {
            string = ((SimpleNode)xMLContainer.getTree().getModel().getRoot()).getContent();
        }
        UseDefaultDialog useDefaultDialog = new UseDefaultDialog("DTD", "Assign a DTD to the current document", "DTD", "dtd", new DTDPathBuilder());
        String string3 = Preferences.getPreference("file", "defaultDTDPath", "");
        useDefaultDialog.setDefaultDirectoryForLocation(string3);
        useDefaultDialog.setRoot(string);
        useDefaultDialog.setXMLFileLocation(xMLContainer.getCurrentDocumentLocation());
        useDefaultDialog.setDelegateForRoots(new DelegateForRoots());
        useDefaultDialog.setVisible(true);
        if (!useDefaultDialog.isOk()) {
            return;
        }
        if (useDefaultDialog.getRoot() == null) {
            EditixFactory.buildAndShowErrorDialog("You must choose a root element");
            return;
        }
        if (useDefaultDialog.toURILocation() == null) {
            EditixFactory.buildAndShowErrorDialog("You must choose a DTD location");
            return;
        }
        string3 = useDefaultDialog.getDefaultDirectoryForLocation();
        if (string3 != null) {
            Preferences.setPreference("file", "defaultDTDPath", string3);
        }
        String string4 = "\n<!DOCTYPE " + useDefaultDialog.getRoot() + " SYSTEM " + "\"" + useDefaultDialog.toURILocation() + "\">\n";
        try {
            if (point != null) {
                xMLDocument.replace(point.x, point.y - point.x + 1, string4, null);
            } else {
                int n = xMLDocument.nextTag(0);
                if (n == 0) {
                    n = xMLDocument.getLength();
                }
                xMLDocument.insertString(n, string4, null);
                String string5 = "<" + useDefaultDialog.getRoot();
                if (xMLDocument.getText(0, xMLDocument.getLength()).indexOf(string5) == -1) {
                    try {
                        String string6 = DTDInstanceGenerator.generateXMLInstance(useDefaultDialog.getRoot(), useDefaultDialog.toURILocation(), null);
                        xMLDocument.insertString(xMLDocument.getLength(), string6, null);
                        ActionModel.activeActionById("format", null);
                    }
                    catch (Throwable throwable) {
                        ApplicationModel.debug(throwable);
                        EditixFactory.buildAndShowErrorDialog("Can't generate the XML instance : " + throwable.getMessage());
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        xMLDocument.parseDTD();
    }

    class DelegateForRoots
    implements UseDefaultRootBuilder {
        DelegateForRoots() {
        }

        public String[] getRoots(String string) {
            DTDParser dTDParser = new DTDParser();
            try {
                String string2 = Toolkit.getContentFromFileName(string);
                dTDParser.parse(new StringReader(string2));
                RootDTDNode rootDTDNode = dTDParser.getDTDElement();
                if (rootDTDNode != null) {
                    ArrayList<String> arrayList = null;
                    for (int i = 0; i < rootDTDNode.getChildCount(); ++i) {
                        DTDNode dTDNode = rootDTDNode.getDTDNodeAt(i);
                        if (!dTDNode.isElement()) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(((ElementDTDNode)dTDNode).getName());
                    }
                    if (arrayList != null) {
                        String[] stringArray = new String[arrayList.size()];
                        for (int i = 0; i < arrayList.size(); ++i) {
                            stringArray[i] = (String)arrayList.get(i);
                        }
                        return stringArray;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }
    }
}

