/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.css.helper;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.editor.XMLDocument;
import com.japisoft.xmlpad.helper.handler.AbstractHelperHandler;
import com.japisoft.xmlpad.helper.model.RawDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.text.BadLocationException;

public class ValuesHandler
extends AbstractHelperHandler {
    static String[] htmlColors = null;
    private ColorAction ca = null;

    protected String getActivatorSequence() {
        return null;
    }

    public String getTitle() {
        return "CSS Values";
    }

    public boolean haveDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, boolean bl, int n, String string) {
        return ":".equals(string) || string == null;
    }

    protected void installDescriptors(SimpleNode simpleNode, XMLDocument xMLDocument, int n, String string) {
        block34: {
            boolean bl;
            block33: {
                String string2 = this.getPreviousWord(xMLDocument, n - 1);
                String string3 = null;
                bl = false;
                if ("font-weight".equals(string2)) {
                    string3 = "normal | bold | bolder | lighter | 100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900 | inherit";
                } else if ("font-stretch".equals(string2)) {
                    string3 = "normal | wider | narrower | ultra-condensed | extra-condensed | condensed | semi-condensed | semi-expanded | expanded | extra-expanded | ultra-expanded | inherit";
                } else if ("font-style".equals(string2)) {
                    string3 = "all | normal | italic | oblique";
                } else if ("font-family".equals(string2)) {
                    string3 = "Arial, Helvetica, sans-serif|\"Times New Roman\", Times, serif|\"Courier New\", Courier, monospace|Georgia, \"Times New Roman\", Times, serif|Verdana, Arial, Helvetica, sans-serif|Geneva, Arial, Helvetica, sans-serif";
                } else if ("text-align".equals(string2)) {
                    string3 = "left | right | center | justify";
                } else if ("vertical-align".equals(string2)) {
                    string3 = "baseline | sub | super | top | text-top | middle | bottom | text-bottom";
                } else if ("text-transform".equals(string2)) {
                    string3 = "none | capitalize | uppercase | lowercase";
                } else if (string2.startsWith("border-") && string2.endsWith("-style")) {
                    string3 = "none | dotted | dashed | solid | double | groove | ridge | inset | outset";
                } else if ("float".equals(string2)) {
                    string3 = "left | right | none";
                } else if ("clear".equals(string2)) {
                    string3 = "none | left | right | both";
                } else if ("list-style-type".equals(string2)) {
                    string3 = "disc | circle | square | decimal | lower-roman | upper-roman | lower-alpha | upper-alpha | none";
                } else if ("list-style-position".equals(string2)) {
                    string3 = "inside | outside";
                } else if ("display".equals(string2)) {
                    string3 = "block | inline | list-item | none";
                } else if ("color".equals(string2) || string2.endsWith("-color")) {
                    bl = true;
                }
                if (string3 == null) break block33;
                String[] stringArray = string3.split("\\|");
                for (int i = 0; i < stringArray.length; ++i) {
                    RawDescriptor rawDescriptor = new RawDescriptor(stringArray[i].trim());
                    rawDescriptor.setAddedPart(string);
                    this.addDescriptor(rawDescriptor);
                }
                break block34;
            }
            if (!bl) break block34;
            RawDescriptor rawDescriptor = (RawDescriptor)this.addDescriptor(new RawDescriptor("Other..."));
            if (this.ca != null && this.ca.lastColor != null) {
                rawDescriptor.setIcon(new ColorIcon(this.ca.lastColor));
            } else {
                rawDescriptor.setIcon(new ColorIcon(Color.WHITE));
            }
            if (this.ca == null) {
                this.ca = new ColorAction(string);
            } else {
                this.ca.activatorString = string;
            }
            rawDescriptor.setSpecificAction(this.ca);
            rawDescriptor.setAddedPart(string);
            for (int i = 0; i < htmlColors.length; ++i) {
                String string4 = htmlColors[i];
                String string5 = string4.substring(1, 7);
                Color color = new Color(Integer.parseInt(string5, 16));
                rawDescriptor = (RawDescriptor)this.addDescriptor(new RawDescriptor(string4.substring(7).trim().toLowerCase()));
                rawDescriptor.setIcon(new ColorIcon(color));
                rawDescriptor.setAddedPart(string);
            }
        }
    }

    private String getPreviousWord(XMLDocument xMLDocument, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            for (int i = n; i >= 0; --i) {
                char c = xMLDocument.getText(i, 1).charAt(0);
                if (c == ':') continue;
                if (c != '{') {
                    if (!Character.isWhitespace(c)) {
                        stringBuffer.insert(0, c);
                        bl = true;
                        continue;
                    }
                    if (!bl) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return stringBuffer.toString().toLowerCase();
    }

    static {
        htmlColors = new String[]{"#000000\tBlack", "#646D7E\tLight Steel Blue4", "#6D7B8D\tLight Slate Gray", "#4C787E\tCadet Blue4", "#4C7D7E\tDark Slate Gray4", "#806D7E\tThistle4", "#5E5A80\tMedium Slate Blue", "#4E387E\tMedium Purple4", "#151B54\tMidnight Blue", "#2B3856\tDark Slate Blue", "#25383C\tDark Slate Gray", "#463E41\tDim Gray", "#151B8D\tCornflower Blue", "#15317E\tRoyal Blue4", "#342D7E\tSlate Blue4", "#2B60DE\tRoyal Blue", "#306EFF\tRoyal Blue1", "#2B65EC\tRoyal Blue2", "#2554C7\tRoyal Blue3", "#3BB9FF\tDeep Sky Blue", "#38ACEC\tDeep Sky Blue2", "#3574EC7\tSlate Blue", "#3090C7\tDeep Sky Blue3", "#25587E\tDeep Sky Blue4", "#1589FF\tDodger Blue", "#157DEC\tDodger Blue2", "#1569C7\tDodger Blue3", "#153E7E\tDodger Blue4", "#2B547E\tSteel Blue4", "#4863A0\tSteel Blue", "#6960EC\tSlate Blue2", "#8D38C9\tViolet", "#7A5DC7\tMedium Purple3", "#8467D7\tMedium Purple", "#9172EC\tMedium Purple2", "#9E7BFF\tMedium Purple1", "#728FCE\tLight Steel Blue", "#488AC7\tSteel Blue3", "#56A5EC\tSteel Blue2", "#5CB3FF\tSteel Blue1", "#659EC7\tSky Blue3", "#41627E\tSky Blue4", "#737CA1\tSlate Blue", "#737CA1\tSlate Blue", "#98AFC7\tSlate Gray3", "#F6358A\tViolet Red", "#F6358A\tViolet Red1", "#E4317F\tViolet Red2", "#F52887\tDeep Pink", "#E4287C\tDeep Pink2", "#C12267\tDeep Pink3", "#7D053F\tDeep Pink4", "#CA226B\tMedium Violet Red", "#C12869\tViolet Red3", "#800517\tFirebrick", "#7D0541\tViolet Red4", "#7D0552\tMaroon4", "#810541\tMaroon", "#C12283\tMaroon3", "#E3319D\tMaroon2", "#F535AA\tMaroon1", "#FF00FF\tMagenta", "#F433FF\tMagenta1", "#E238EC\tMagenta2", "#C031C7\tMagenta3", "#B048B5\tMedium Orchid", "#D462FF\tMedium Orchid1", "#C45AEC\tMedium Orchid2", "#A74AC7\tMedium Orchid3", "#6A287E\tMedium Orchid4", "#8E35EF\tPurple", "#893BFF\tPurple1", "#7F38EC\tPurple2", "#6C2DC7\tPurple3", "#461B7E\tPurple4", "#571B7e\tDark Orchid4", "#7D1B7E\tDark Orchid", "#842DCE\tDark Violet", "#8B31C7\tDark Orchid3", "#A23BEC\tDark Orchid2", "#B041FF\tDark Orchid1", "#7E587E\tPlum4", "#D16587\tPale Violet Red", "#F778A1\tPale Violet Red1", "#E56E94\tPale Violet Red2", "#C25A7C\tPale Violet Red3", "#7E354D\tPale Violet Red4", "#B93B8F\tPlum", "#F9B7FF\tPlum1", "#E6A9EC\tPlum2", "#C38EC7\tPlum3", "#D2B9D3\tThistle", "#C6AEC7\tThistle3", "#EBDDE2\tLavender Blush2", "#C8BBBE\tLavender Blush3", "#E9CFEC\tThistle2", "#FCDFFF\tThistle1", "#E3E4FA\tLavender", "#FDEEF4\tLavender Blush", "#C6DEFF\tLight Steel Blue1", "#ADDFFF\tLight Blue", "#BDEDFF\tLight Blue1", "#E0FFFF\tLight Cyan", "#C2DFFF\tSlate Gray1", "#B4CFEC\tSlate Gray2", "#B7CEEC\tLight Steel Blue2", "#52F3FF\tTurquoise1", "#00FFFF\tCyan", "#57FEFF\tCyan1", "#50EBEC\tCyan2", "#4EE2EC\tTurquoise2", "#48CCCD\tMedium Turquoise", "#43C6DB\tTurquoise", "#9AFEFF\tDark Slate Gray1", "#8EEBEC\tDark slate Gray2", "#78c7c7\tDark Slate Gray3", "#46C7C7\tCyan3", "#43BFC7\tTurquoise3", "#77BFC7\tCadet Blue3", "#92C7C7\tPale Turquoise3", "#AFDCEC\tLight Blue2", "#3B9C9C\tDark Turquoise", "#307D7E\tCyan4", "#3EA99F\tLight Sea Green", "#82CAFA\tLight Sky Blue", "#A0CFEC\tLight Sky Blue2", "#87AFC7\tLight Sky Blue3", "#82CAFF\tSky Blue", "#79BAEC\tSky Blue2", "#566D7E\tLight Sky Blue4", "#6698FF\tSky Blue", "#736AFF\tLight Slate Blue", "#CFECEC\tLight Cyan2", "#AFC7C7\tLight Cyan3", "#717D7D\tLight Cyan4", "#95B9C7\tLight Blue3", "#5E767E\tLight Blue4", "#5E7D7E\tPale Turquoise4", "#617C58\tDark Sea Green4", "#348781\tMedium Aquamarine", "#306754\tMedium Sea Green", "#4E8975\tSea Green", "#254117\tDark Green", "#387C44\tSea Green4", "#4E9258\tForest Green", "#347235\tMedium Forest Green", "#347C2C\tSpring Green4", "#667C26\tDark Olive Green4", "#437C17\tChartreuse4", "#347C17\tGreen4", "#348017\tMedium Spring Green", "#4AA02C\tSpring Green", "#41A317\tLime Green", "#4AA02C\tSpring Green", "#8BB381\tDark Sea Green", "#99C68E\tDark Sea Green3", "#4CC417\tGreen3", "#6CC417\tChartreuse3", "#52D017\tYellow Green", "#4CC552\tSpring Green3", "#54C571\tSea Green3", "#57E964\tSpring Green2", "#5EFB6E\tSpring Green1", "#64E986\tSea Green2", "#6AFB92\tSea Green1", "#B5EAAA\tDark Sea Green2", "#C3FDB8\tDark Sea Green1", "#00FF00\tGreen", "#87F717\tLawn Green", "#5FFB17\tGreen1", "#59E817\tGreen2", "#7FE817\tChartreuse2", "#8AFB17\tChartreuse", "#B1FB17\tGreen Yellow", "#CCFB5D\tDark Olive Green1", "#BCE954\tDark Olive Green2", "#A0C544\tDark Olive Green3", "#FFFF00\tYellow", "#FFFC17\tYellow1", "#FFF380\tKhaki1", "#EDE275\tKhaki2", "#EDDA74\tGoldenrod", "#EAC117\tGold2", "#FDD017\tGold1", "#FBB917\tGoldenrod1", "#E9AB17\tGoldenrod2", "#D4A017\tGold", "#C7A317\tGold3", "#C68E17\tGoldenrod3", "#AF7817\tDark Goldenrod", "#ADA96E\tKhaki", "#C9BE62\tKhaki3", "#827839\tKhaki4", "#FBB117\tDark Goldenrod1", "#E8A317\tDark Goldenrod2", "#C58917\tDark Goldenrod3", "#F87431\tSienna1", "#E66C2C\tSienna2", "#F88017\tDark Orange", "#F87217\tDark Orange1", "#E56717\tDark Orange2", "#C35617\tDark Orange3", "#C35817\tSienna3", "#8A4117\tSienna", "#7E3517\tSienna4", "#7E2217\tIndian Red4", "#7E3117\tDark Orange3", "#7E3817\tSalmon4", "#7F5217\tDark Goldenrod4", "#806517\tGold4", "#805817\tGoldenrod4", "#7F462C\tLight Salmon4", "#C85A17\tChocolate", "#C34A2C\tCoral3", "#E55B3C\tCoral2", "#F76541\tCoral", "#E18B6B\tDark Salmon", "#F88158\tPale Turquoise4", "#E67451\tSalmon2", "#C36241\tSalmon3", "#C47451\tLight Salmon3", "#E78A61\tLight Salmon2", "#F9966B\tLight Salmon", "#EE9A4D\tSandy Brown", "#F660AB\tHot Pink", "#F665AB\tHot Pink1", "#E45E9D\tHot Pink2", "#C25283\tHot Pink3", "#7D2252\tHot Pink4", "#E77471\tLight Coral", "#F75D59\tIndian Red1", "#E55451\tIndian Red2", "#C24641\tIndian Red3", "#FF0000\tRed", "#F62217\tRed1", "#E41B17\tRed2", "#F62817\tFirebrick1", "#E42217\tFirebrick2", "#C11B17\tFirebrick3", "#FAAFBE\tPink", "#FBBBB9\tRosy Brown1", "#E8ADAA\tRosy Brown2", "#E7A1B0\tPink2", "#FAAFBA\tLight Pink", "#F9A7B0\tLight Pink1", "#E799A3\tLight Pink2", "#C48793\tPink3", "#C5908E\tRosy Brown3", "#B38481\tRosy Brown", "#C48189\tLight Pink3", "#7F5A58\tRosy Brown4", "#7F4E52\tLight Pink4", "#7F525D\tPink4", "#817679\tLavendar Blush4", "#817339\tLight Goldenrod4", "#827B60\tLemon Chiffon4", "#C9C299\tLemon Chiffon3", "#C8B560\tLight Goldenrod3", "#ECD672\tLight Golden2", "#ECD872\tLight Goldenrod", "#FFE87C\tLight Goldenrod1", "#ECE5B6\tLemon Chiffon2", "#FFF8C6\tLemon Chiffon", "#FAF8CC\tLight Goldenrod Yellow", "#150517\tGray0", "#250517\tGray18", "#2B1B17\tGray21", "#302217\tGray23", "#302226\tGray24", "#342826\tGray25", "#34282C\tGray26", "#382D2C\tGray27", "#3b3131\tGray28", "#3E3535\tGray29", "#413839\tGray30", "#41383C\tGray31", "#463E3F\tGray32", "#4A4344\tGray34", "#4C4646\tGray35", "#4E4848\tGray36", "#504A4B\tGray37", "#544E4F\tGray38", "#565051\tGray39", "#595454\tGray40", "#5C5858\tGray41", "#5F5A59\tGray42", "#625D5D\tGray43", "#646060\tGray44", "#666362\tGray45", "#696565\tGray46", "#6D6968\tGray47", "#6E6A6B\tGray48", "#726E6D\tGray49", "#747170\tGray50", "#736F6E\tGray", "#616D7E\tSlate Gray4", "#657383\tSlate Gray"};
    }

    class ColorAction
    extends AbstractAction {
        private Color lastColor = null;
        String activatorString = null;

        ColorAction(String string) {
            this.activatorString = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.lastColor = JColorChooser.showDialog(null, "CSS color", this.lastColor);
            if (this.lastColor != null) {
                String string;
                String string2;
                int n = this.lastColor.getRed();
                int n2 = this.lastColor.getGreen();
                int n3 = this.lastColor.getBlue();
                String string3 = Integer.toHexString(n);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if ((string2 = Integer.toHexString(n2)).length() == 1) {
                    string2 = "0" + string2;
                }
                if ((string = Integer.toHexString(n3)).length() == 1) {
                    string = "0" + string;
                }
                String string4 = string3 + string2 + string;
                RawDescriptor rawDescriptor = new RawDescriptor("#" + string4);
                this.putValue("descriptor", rawDescriptor);
                rawDescriptor.setAddedPart(this.activatorString);
            } else {
                RawDescriptor rawDescriptor = new RawDescriptor("");
                rawDescriptor.setAddedPart(this.activatorString);
                this.putValue("descriptor", rawDescriptor);
            }
        }
    }

    class ColorIcon
    implements Icon {
        private Color c;

        ColorIcon(Color color) {
            this.c = color;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.c);
            graphics.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.draw3DRect(0, 0, this.getIconWidth(), this.getIconHeight(), true);
        }
    }
}

