/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.FileCopyException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tools {
    private static void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        if (inputStream == null) {
            throw new IOException("Trying to input from a null stream");
        }
        if (outputStream == null) {
            throw new IOException("Trying to output to a null stream");
        }
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private static void streamCopyAndClose(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOException iOException;
        block10: {
            block9: {
                iOException = null;
                try {
                    Tools.streamCopy(inputStream, outputStream);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException3) {
                        if (iOException == null) break block9;
                        iOException = new IOException(iOException.getMessage() + " (and I was not able to close this stream)");
                    }
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException4) {
                    if (iOException == null) break block10;
                    iOException = new IOException(iOException.getMessage() + " (and I was not able to close this stream)");
                }
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OutputStream openToWrite(File file) throws FileCopyException {
        Object object;
        Object var1_1 = null;
        if (file.exists()) {
            if (!file.isFile()) throw new FileCopyException(file + " is not a file.");
            object = new DataInputStream(System.in);
            if (!file.canWrite()) {
                throw new FileCopyException("Can't write into " + file);
            }
        } else {
            object = Tools.parent(file);
            if (!((File)object).exists()) {
                throw new FileCopyException("Destination directory doesn't exist for " + file);
            }
            if (!((File)object).canWrite()) {
                throw new FileCopyException("Destination directory for " + file + " is unwritable.");
            }
        }
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileCopyException("Can't write to " + file + " because " + fileNotFoundException.getLocalizedMessage());
        }
    }

    public static void copyFromResource(String string, File file) throws FileCopyException {
        InputStream inputStream = Tools.class.getResourceAsStream(string);
        if (inputStream == null) {
            String string2 = "Unable to find " + string + ".";
            if (!string.startsWith("/")) {
                string2 = string2 + " Please note that name doesn't start with a slash '/'.";
            }
            throw new FileCopyException(string2);
        }
        OutputStream outputStream = Tools.openToWrite(file);
        try {
            Tools.streamCopyAndClose(inputStream, outputStream);
        }
        catch (IOException iOException) {
            throw new FileCopyException("Unable to copy " + string + " into " + file);
        }
    }

    public static void copy(File file, File file2) throws IOException {
        if (!file.exists() || !file.isFile()) {
            throw new FileCopyException("Can't find " + file);
        }
        if (!file.canRead()) {
            throw new FileCopyException("File " + file + " is unreadable");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        OutputStream outputStream = Tools.openToWrite(file2);
        try {
            Tools.streamCopyAndClose(fileInputStream, outputStream);
        }
        catch (IOException iOException) {
            throw new FileCopyException("Unable to copy " + file + " into " + file2);
        }
    }

    public static File parent(File file) {
        String string = file.getParent();
        if (string == null) {
            if (file.isAbsolute()) {
                return new File(File.separator);
            }
            return new File(System.getProperty("user.dir"));
        }
        return new File(string);
    }

    public static Collection sort(Collection collection, Comparator comparator) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static String[] listToArray(String string, String string2) {
        if (string == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        if (vector.size() <= 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public static String escapeHTMLUnicode(String string, boolean bl) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl && c == '\'') {
                    stringBuffer.append("\\'");
                    continue;
                }
                if (c < '\u0080') {
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append("&#").append((int)c).append(";");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static LinkedList enumerationToList(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        while (enumeration.hasMoreElements()) {
            linkedList.add(enumeration.nextElement());
        }
        return linkedList;
    }

    public static String getFilename(String string) {
        int n = string.lastIndexOf(File.separator) + 1;
        return string.substring(n);
    }

    public static void makeFileDir(File file) throws IOException {
        String string = file.getCanonicalPath();
        File file2 = new File(string.substring(0, string.lastIndexOf(File.separator)));
        file2.mkdirs();
    }

    public static URI pathToURI(String string) {
        try {
            return new URI(string.replace(File.separatorChar, '/'));
        }
        catch (URISyntaxException uRISyntaxException) {
            System.out.println("Unable to create a URI out of the path '" + string + "' because " + uRISyntaxException);
            return null;
        }
    }
}

