/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.cdlib.xtf.util.CharMap;
import org.cdlib.xtf.util.FastCache;

public class WordMap {
    private static final int CACHE_SIZE = 5000;
    private FastCache cache = new FastCache(5000);
    private HashMap blockMap = new HashMap(100);
    private ArrayList blockHeads = new ArrayList(100);

    public WordMap(File f, CharMap charMap) throws IOException {
        this.readFile(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8")), charMap);
    }

    public WordMap(InputStream s, CharMap charMap) throws IOException {
        this.readFile(new BufferedReader(new InputStreamReader(s, "UTF-8")), charMap);
    }

    public synchronized String lookup(String word) {
        String val = null;
        if (this.cache.contains(word)) {
            val = (String)this.cache.get(word);
            return val;
        }
        int blockNum = Collections.binarySearch(this.blockHeads, word);
        if (blockNum < 0) {
            blockNum = -blockNum - 2;
        }
        if (blockNum < 0) {
            this.cache.put(word, null);
            return null;
        }
        String prev = (String)this.blockHeads.get(blockNum);
        String block = (String)this.blockMap.get(prev);
        int pos = 0;
        while (pos < block.length()) {
            int keyShare = block.charAt(pos) - 48;
            int barPos = block.indexOf(124, pos + 1);
            String key = String.valueOf(prev.substring(0, keyShare)) + block.substring(pos + 1, barPos);
            int end = block.indexOf(10, barPos + 1);
            int comp = key.compareTo(word);
            if (comp > 0) break;
            if (comp != 0) {
                pos = end + 1;
                if (pos < 0) break;
                prev = key;
                continue;
            }
            int valShare = block.charAt(barPos + 1) - 48;
            val = String.valueOf(key.substring(0, valShare)) + block.substring(barPos + 2, end);
            this.cache.put(word, val);
            return val;
        }
        this.cache.put(word, null);
        return null;
    }

    private void readFile(BufferedReader reader, CharMap charMap) throws IOException {
        String line;
        TreeMap<String, String> entries = new TreeMap<String, String>();
        HashMap<String, String> randomCheck = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            int barPos;
            if (line.indexOf("//") >= 0) {
                line = line.substring(0, line.indexOf("//"));
            }
            if (line.indexOf("#") >= 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            if (line.indexOf(";") >= 0) {
                line = line.substring(0, line.indexOf(";"));
            }
            if ((barPos = line.indexOf(124)) < 0) continue;
            String key = line.substring(0, barPos).trim();
            String val = line.substring(barPos + 1).trim();
            if (key.length() == 0 || val.length() == 0) continue;
            if (charMap != null) {
                String newVal;
                String newKey = charMap.mapWord(key);
                if (newKey != null) {
                    key = newKey;
                }
                if ((newVal = charMap.mapWord(val)) != null) {
                    val = newVal;
                }
            }
            entries.put(key, val);
        }
        StringBuffer buf = new StringBuffer();
        int nEntries = 0;
        String prev = "";
        String firstKey = "";
        Iterator iter = entries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (firstKey.length() == 0) {
                prev = firstKey = key;
            }
            int keyShare = 0;
            while (keyShare < key.length()) {
                if (keyShare == prev.length() || key.charAt(keyShare) != prev.charAt(keyShare)) break;
                ++keyShare;
            }
            int valShare = 0;
            while (valShare < key.length()) {
                if (valShare == val.length() || key.charAt(valShare) != val.charAt(valShare)) break;
                ++valShare;
            }
            buf.append(String.valueOf((char)(keyShare + 48)) + key.substring(keyShare) + '|' + (char)(valShare + 48) + val.substring(valShare) + "\n");
            prev = key;
            if (Math.random() < 0.01) {
                randomCheck.put(key, val);
            }
            if (++nEntries != 128 && iter.hasNext()) continue;
            String block = buf.toString();
            this.blockMap.put(firstKey, block);
            this.blockHeads.add(firstKey);
            nEntries = 0;
            prev = "";
            firstKey = "";
            buf.setLength(0);
        }
        for (Map.Entry ent : randomCheck.entrySet()) {
            String result = this.lookup((String)ent.getKey());
            assert (result.equals(ent.getValue()));
        }
        assert (this.lookup("a") == null);
        assert (this.lookup("zzzzzz") == null);
        this.cache.clear();
    }
}

