/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.cdlib.xtf.util.StructuredFile;
import org.cdlib.xtf.util.SubStoreReader;

class SubFileReader
extends SubStoreReader {
    private RandomAccessFile file;
    private StructuredFile parent;
    private long segOffset;
    private long segLength;
    private long curPos;

    SubFileReader(RandomAccessFile file, StructuredFile parent, long segOffset, long segLength) throws IOException {
        this.file = file;
        this.parent = parent;
        this.segOffset = segOffset;
        this.segLength = segLength;
        this.curPos = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.parent.closeReader(this);
            this.file = null;
        }
    }

    public long getFilePointer() throws IOException {
        return this.curPos;
    }

    public long length() throws IOException {
        return this.segLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLength(int nBytes) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            if (this.parent.curSubFile != this) {
                this.file.seek(this.segOffset + this.curPos);
                this.parent.curSubFile = this;
            }
            if (this.curPos + (long)nBytes > this.segLength) {
                throw new EOFException("End of sub-file reached");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(byte[] b, int off, int len) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(len);
            this.file.readFully(b, off, len);
            this.curPos += (long)len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long pos) throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            if (this.segLength >= 0L && pos > this.segLength) {
                throw new EOFException("Cannot seek past end of subfile");
            }
            this.parent.curSubFile = this;
            this.file.seek(pos + this.segOffset);
            this.curPos = pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(1);
            byte ret = this.file.readByte();
            ++this.curPos;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInt() throws IOException {
        StructuredFile structuredFile = this.parent;
        synchronized (structuredFile) {
            this.checkLength(4);
            int ret = this.file.readInt();
            this.curPos += 4L;
            return ret;
        }
    }
}

