/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.Linkable;

public class EmbeddedList {
    private Linkable head;
    private Linkable tail;
    private int count = 0;

    public void addHead(Linkable l) {
        if (l.getOwner() != null) {
            throw new IllegalArgumentException();
        }
        l.setOwner(this);
        assert (l.getPrev() == null);
        assert (l.getNext() == null);
        l.setPrev(null);
        l.setNext(this.head);
        if (this.head != null) {
            this.head.setPrev(l);
        }
        this.head = l;
        if (this.tail == null) {
            this.tail = l;
        }
        ++this.count;
    }

    public void addTail(Linkable l) {
        if (l.getOwner() != null) {
            throw new IllegalArgumentException();
        }
        l.setOwner(this);
        assert (l.getPrev() == null);
        assert (l.getNext() == null);
        l.setPrev(this.tail);
        l.setNext(null);
        if (this.tail != null) {
            this.tail.setNext(l);
        }
        this.tail = l;
        if (this.head == null) {
            this.head = l;
        }
        ++this.count;
    }

    public Linkable getHead() {
        return this.head;
    }

    public Linkable getTail() {
        return this.tail;
    }

    public int getCount() {
        return this.count;
    }

    public Linkable removeHead() {
        if (this.head == null) {
            return null;
        }
        return this.remove(this.head);
    }

    public Linkable removeTail() {
        if (this.tail == null) {
            return null;
        }
        return this.remove(this.tail);
    }

    public void moveToHead(Linkable l) {
        if (l.getOwner() != this) {
            throw new IllegalArgumentException();
        }
        if (l == this.head) {
            return;
        }
        this.addHead(this.remove(l));
    }

    public void moveToTail(Linkable l) {
        if (l.getOwner() != this) {
            throw new IllegalArgumentException();
        }
        if (l == this.tail) {
            return;
        }
        this.addTail(this.remove(l));
    }

    public Linkable remove(Linkable l) {
        Linkable prev = l.getPrev();
        Linkable next = l.getNext();
        if (l.getOwner() != this) {
            throw new IllegalArgumentException();
        }
        l.setOwner(null);
        if (prev != null) {
            assert (this.head != l);
            prev.setNext(next);
        } else {
            assert (this.head == l);
            this.head = next;
        }
        if (next != null) {
            assert (this.tail != l);
            next.setPrev(prev);
        } else {
            assert (this.tail == l);
            this.tail = prev;
        }
        l.setPrev(null);
        l.setNext(null);
        --this.count;
        return l;
    }
}

