/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.util;

import org.cdlib.xtf.util.Tester;

public class CircularQueue {
    private int maxSize;
    private Object[] entries;
    private int bottom;
    private int count;
    public static final Tester tester = new Tester("CircularQueue"){

        protected void testImpl() {
            CircularQueue queue = new CircularQueue(3);
            Integer one = 1;
            Integer two = 2;
            Integer three = 3;
            Integer four = 4;
            if (!$assertionsDisabled && queue.count() != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !queue.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.removeHead() != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.removeTail() != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != null) {
                throw new AssertionError();
            }
            queue.addTail(one);
            queue.addTail(two);
            if (!$assertionsDisabled && queue.isEmpty()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.count() != 2) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != one) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != two) {
                throw new AssertionError();
            }
            queue.addTail(three);
            queue.addTail(four);
            if (!$assertionsDisabled && queue.count() != 3) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != two) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != three) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(2) != four) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(3) != null) {
                throw new AssertionError();
            }
            queue.addHead(one);
            if (!$assertionsDisabled && queue.count() != 3) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != one) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != two) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(2) != three) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(3) != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.removeHead() != one) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.removeTail() != three) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.count() != 1) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != two) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != null) {
                throw new AssertionError();
            }
            queue.addHead(one);
            queue.addTail(three);
            if (!$assertionsDisabled && queue.count() != 3) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(0) != one) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(1) != two) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(2) != three) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && queue.peek(3) != null) {
                throw new AssertionError();
            }
        }
    };

    public CircularQueue(int maxSize) {
        this.maxSize = maxSize;
        this.entries = new Object[maxSize];
    }

    public final void addTail(Object obj) {
        if (this.count == this.maxSize) {
            this.removeHead();
        }
        int next = this.bottom + this.count >= this.maxSize ? this.bottom + this.count - this.maxSize : this.bottom + this.count;
        this.entries[next] = obj;
        ++this.count;
    }

    public final void addHead(Object obj) {
        if (this.count == this.maxSize) {
            this.removeTail();
        }
        this.bottom = this.bottom == 0 ? this.maxSize - 1 : this.bottom - 1;
        this.entries[this.bottom] = obj;
        ++this.count;
    }

    public final Object removeHead() {
        if (this.count == 0) {
            return null;
        }
        int first = this.bottom;
        this.bottom = this.bottom == this.maxSize - 1 ? 0 : ++this.bottom;
        --this.count;
        return this.entries[first];
    }

    public final Object removeTail() {
        if (this.count == 0) {
            return null;
        }
        int last = this.bottom + this.count - 1;
        if (last == this.maxSize) {
            last = 0;
        }
        --this.count;
        return this.entries[last];
    }

    public final Object peek(int distance) {
        if (this.count == 0) {
            return null;
        }
        if (distance >= this.count) {
            return null;
        }
        int n = this.bottom + distance;
        if (n >= this.maxSize) {
            n -= this.maxSize;
        }
        return this.entries[n];
    }

    public final void clear() {
        this.count = 0;
        this.bottom = 0;
    }

    public final int count() {
        return this.count;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final boolean isFull() {
        return this.count == this.maxSize;
    }
}

