/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textIndexer;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.cdlib.xtf.util.FastCache;
import org.cdlib.xtf.util.Normalizer;

public class UnicodeNormalizingFilter
extends TokenFilter {
    private static final int CACHE_SIZE = 5000;
    private FastCache<String, String> cache = new FastCache(5000);

    public UnicodeNormalizingFilter(TokenStream input) {
        super(input);
    }

    public Token next() throws IOException {
        String newText;
        Token t = this.input.next();
        if (t == null) {
            return null;
        }
        String text = t.termText();
        if (!this.cache.contains(text)) {
            String normalizedText = Normalizer.normalize(text);
            this.cache.put(text, normalizedText);
        }
        if (!(newText = this.cache.get(text)).equals(text)) {
            t.setTermText(newText);
        }
        return t;
    }
}

