/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.IntList;
import org.apache.lucene.util.Prime;
import org.cdlib.xtf.textEngine.facet.DynamicGroupData;
import org.cdlib.xtf.textEngine.facet.FRBRData;
import org.cdlib.xtf.util.FloatList;
import org.cdlib.xtf.util.TagChars;
import org.cdlib.xtf.util.Trace;

public class FRBRGroupData
extends DynamicGroupData {
    private String params;
    private FRBRData data;
    private IntList docs = new IntList();
    private int maxDoc = 0;
    private FloatList docScores = new FloatList();
    private IntList docGroups;
    private IntList groupDocs;
    private IntList groupDocCounts;
    private FloatList groupScores;
    private int nGroups = 1;
    private int primarySort = 1;
    private boolean reversePrimarySort = false;
    private IntList matchTags1 = new IntList();
    private IntList matchTags2 = new IntList();
    private TagChars chars1 = new TagChars();
    private TagChars chars2 = new TagChars();
    private int wordHashKey = 0;
    private static final int WORD_HASH_SIZE = Prime.findAfter(1000000);
    private int[] wordHash = new int[WORD_HASH_SIZE];
    private static final char[] charType = new char[65536];

    static {
        FRBRGroupData.charType[32] = 112;
        FRBRGroupData.charType[9] = 112;
        FRBRGroupData.charType[10] = 112;
        FRBRGroupData.charType[13] = 112;
        FRBRGroupData.charType[12] = 112;
        FRBRGroupData.charType[39] = 112;
        FRBRGroupData.charType[34] = 112;
        FRBRGroupData.charType[46] = 112;
        FRBRGroupData.charType[38] = 112;
        FRBRGroupData.charType[64] = 112;
        FRBRGroupData.charType[45] = 112;
        FRBRGroupData.charType[47] = 112;
        FRBRGroupData.charType[44] = 112;
        FRBRGroupData.charType[58] = 112;
        FRBRGroupData.charType[59] = 112;
        FRBRGroupData.charType[40] = 112;
        FRBRGroupData.charType[41] = 112;
        FRBRGroupData.charType[91] = 112;
        FRBRGroupData.charType[93] = 112;
    }

    public void init(IndexReader indexReader, Set tokFields, String params) throws IOException {
        this.params = params;
        StringTokenizer t = new StringTokenizer(params, " \t,;|");
        ArrayList<String> fields = new ArrayList<String>(t.countTokens());
        while (t.hasMoreTokens()) {
            String tok = t.nextToken();
            if (tok.startsWith("[")) {
                if (tok.equals("[sort=title]")) {
                    this.primarySort = 1;
                    continue;
                }
                if (tok.equals("[sort=author]")) {
                    this.primarySort = 2;
                    continue;
                }
                if (tok.equals("[sort=date]")) {
                    this.primarySort = 3;
                    continue;
                }
                if (tok.equals("[sort=-date]")) {
                    this.primarySort = 3;
                    this.reversePrimarySort = true;
                    continue;
                }
                if (tok.equals("[sort=id]")) {
                    this.primarySort = 4;
                    continue;
                }
                throw new RuntimeException("Unknown control marker: " + tok);
            }
            if (tokFields.contains(tok)) {
                throw new RuntimeException("XTF's FRBR algorithms cannot work with tokenized fields, e.g. '" + tok + "'");
            }
            fields.add(tok);
        }
        this.data = FRBRData.getCachedTags(indexReader, fields.toArray(new String[fields.size()]));
    }

    public void collect(int doc, float score) {
        assert (this.docs.isEmpty() || this.docs.getLast() < doc) : "docs out of order";
        this.docs.add(doc);
        this.docScores.add(score);
        this.maxDoc = Math.max(this.maxDoc, doc);
    }

    public void finish() {
        int doc;
        Trace.debug("Building FRBR groups for " + this.docs.size() + " docs...");
        Trace.tab();
        this.docs.compact();
        this.docScores.compact();
        this.docGroups = new IntList(this.maxDoc + 1);
        this.docGroups.fill(-1);
        int i = 0;
        while (i < this.docs.size()) {
            doc = this.docs.get(i);
            if (this.docGroups.get(doc) < 0) {
                this.findGroup(doc);
            }
            ++i;
        }
        Trace.debug(String.valueOf(this.nGroups) + " groups. Inverting map...");
        this.groupDocs = new IntList(this.nGroups);
        this.groupDocCounts = new IntList(this.nGroups);
        this.groupScores = new FloatList(this.nGroups);
        i = 0;
        while (i < this.docs.size()) {
            doc = this.docs.get(i);
            float score = this.docScores.get(i);
            int group = this.docGroups.get(doc);
            assert (group >= 0) : "group should have been assigned";
            if (this.groupDocs.get(group) == 0) {
                this.groupDocs.set(group, doc);
            }
            this.groupDocCounts.set(group, this.groupDocCounts.get(group) + 1);
            this.groupScores.set(group, Math.max(this.groupScores.get(group), score));
            this.groupScores.set(0, Math.max(this.groupScores.get(0), score));
            ++i;
        }
        this.groupDocCounts.set(0, this.docs.size());
        Trace.debug("Done.");
        Trace.untab();
    }

    private void findGroup(int mainDoc) {
        this.docGroups.set(mainDoc, this.nGroups++);
        int pos = this.data.docTags.firstPos(mainDoc);
        while (pos >= 0) {
            int mainTitle = this.data.docTags.getValue(pos);
            if (this.data.tags.getType(mainTitle) == 1) {
                int compTitle = mainTitle;
                while (compTitle >= 0) {
                    if (!this.matchOnTitle(mainDoc, mainTitle, compTitle)) break;
                    compTitle = this.data.tags.next(compTitle);
                }
                compTitle = this.data.tags.prev(mainTitle);
                while (compTitle >= 0) {
                    if (!this.matchOnTitle(mainDoc, mainTitle, compTitle)) break;
                    compTitle = this.data.tags.prev(compTitle);
                }
            }
            pos = this.data.docTags.nextPos(pos);
        }
    }

    private boolean matchOnTitle(int mainDoc, int mainTitle, int compTitle) {
        if (mainTitle != compTitle && !this.matchPartialTitle(mainTitle, compTitle)) {
            return false;
        }
        int pos = this.data.tagDocs.firstPos(compTitle);
        while (pos >= 0) {
            int compDoc = this.data.tagDocs.getValue(pos);
            if (compDoc != mainDoc && this.docs.binarySearch(compDoc) >= 0) {
                if (this.docGroups.get(compDoc) >= 0) {
                    this.docGroups.get(compDoc);
                    this.docGroups.get(mainDoc);
                } else if (this.multiFieldMatch(mainDoc, compDoc)) {
                    int group = this.docGroups.get(mainDoc);
                    this.docGroups.set(compDoc, group);
                }
            }
            pos = this.data.tagDocs.nextPos(pos);
        }
        return true;
    }

    private boolean multiFieldMatch(int doc1, int doc2) {
        int titleScore = 0;
        int authorScore = 0;
        int dateScore = 0;
        int idScore = 0;
        int p1 = this.data.docTags.firstPos(doc1);
        int tag1 = p1 >= 0 ? this.data.docTags.getValue(p1) : -1;
        int type1 = p1 >= 0 ? this.data.tags.getType(tag1) : 99;
        int p2 = this.data.docTags.firstPos(doc2);
        int tag2 = p2 >= 0 ? this.data.docTags.getValue(p2) : -1;
        int type2 = p2 >= 0 ? this.data.tags.getType(tag2) : 99;
        while (p1 >= 0 || p2 >= 0) {
            int curType = Math.min(type1, type2);
            assert (curType != 99);
            this.matchTags1.clear();
            while (type1 == curType) {
                this.matchTags1.add(tag1);
                p1 = this.data.docTags.nextPos(p1);
                tag1 = p1 >= 0 ? this.data.docTags.getValue(p1) : -1;
                int n = type1 = p1 >= 0 ? this.data.tags.getType(tag1) : 99;
            }
            this.matchTags2.clear();
            while (type2 == curType) {
                this.matchTags2.add(tag2);
                p2 = this.data.docTags.nextPos(p2);
                tag2 = p2 >= 0 ? this.data.docTags.getValue(p2) : -1;
                int n = type2 = p2 >= 0 ? this.data.tags.getType(tag2) : 99;
            }
            switch (curType) {
                case 1: {
                    this.debugFieldMatch("title", doc1, doc2);
                    titleScore = this.scoreTitleMatch(this.matchTags1, this.matchTags2);
                    break;
                }
                case 2: {
                    this.debugFieldMatch("author", doc1, doc2);
                    authorScore = this.scoreAuthorMatch(this.matchTags1, this.matchTags2);
                    break;
                }
                case 3: {
                    this.debugFieldMatch("date", doc1, doc2);
                    dateScore = this.scoreDateMatch(this.matchTags1, this.matchTags2);
                    break;
                }
                case 4: {
                    this.debugFieldMatch("id", doc1, doc2);
                    idScore = this.scoreIdMatch(this.matchTags1, this.matchTags2);
                }
            }
        }
        assert (p1 < 0 && p2 < 0);
        int totalScore = titleScore + authorScore + dateScore + idScore;
        return totalScore >= 150;
    }

    private void debugFieldMatch(String field, int doc1, int doc2) {
    }

    private void outputDisplayKey(String title, int doc) {
        int nToSkip = 0;
        int[] nArray = new int[5];
        nArray[1] = 50;
        nArray[2] = 40;
        nArray[3] = 4;
        nArray[4] = 30;
        int[] fieldMax = nArray;
        String spaces = "                                                             ";
        int found = 0;
        do {
            StringBuffer buf = new StringBuffer();
            found = 0;
            int t = 1;
            while (t <= 4) {
                int skipped = 0;
                String value = "";
                int pos = this.data.docTags.firstPos(doc);
                while (pos >= 0) {
                    int tag = this.data.docTags.getValue(pos);
                    int type = this.data.tags.getType(tag);
                    short subType = this.data.tags.getSubType(tag);
                    if (type == t && skipped++ == nToSkip) {
                        value = String.valueOf(this.data.tags.getString(tag)) + " [" + subType + "]";
                        ++found;
                    }
                    pos = this.data.docTags.nextPos(pos);
                }
                int lenToKeep = Math.min(value.length(), fieldMax[t]);
                if (buf.length() > 0) {
                    buf.append(" | ");
                }
                buf.append(String.valueOf(value.substring(0, lenToKeep)) + "                                                             ".substring(0, fieldMax[t] - lenToKeep));
                ++t;
            }
            if (found <= 0 && nToSkip != 0) continue;
            Trace.debug(String.valueOf(title) + buf);
            title = "                                                             ".substring(0, title.length());
            ++nToSkip;
        } while (found > 0);
    }

    private int scoreTitleMatch(IntList list1, IntList list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return 0;
        }
        int p1 = 0;
        int p2 = 0;
        int size1 = list1.size();
        int size2 = list2.size();
        int nMatches = 0;
        int skipped1 = 0;
        int skipped2 = 0;
        int maxScore = 100;
        while (p1 < size1 && p2 < size2) {
            short subType2;
            int tag1 = list1.get(p1);
            int tag2 = list2.get(p2);
            short subType1 = this.data.tags.getSubType(tag1);
            if (subType1 == (subType2 = this.data.tags.getSubType(tag2))) {
                if (tag1 == tag2) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    continue;
                }
                if (this.matchPartialTitle(tag1, tag2)) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    maxScore = 80;
                    continue;
                }
            }
            if (tag1 < tag2) {
                ++skipped1;
                ++p1;
                continue;
            }
            ++skipped2;
            ++p2;
        }
        if ((skipped1 += size1 - p1) == 0 && (skipped2 += size2 - p2) == 0) {
            assert (nMatches > 0);
            return maxScore;
        }
        if (nMatches > 0 && (skipped1 == 0 || skipped2 == 0)) {
            return 80;
        }
        return -100;
    }

    private boolean matchPartialTitle(int tag1, int tag2) {
        this.data.tags.getChars(tag1, this.chars1);
        this.data.tags.getChars(tag2, this.chars2);
        int prefixMatch = this.chars1.prefixMatch(this.chars2);
        if (prefixMatch < 10) {
            return false;
        }
        int colonPos = this.chars1.indexOf(':');
        if (colonPos >= 10) {
            return prefixMatch == this.chars2.length() && prefixMatch >= colonPos;
        }
        colonPos = this.chars2.indexOf(':');
        if (colonPos >= 10) {
            return prefixMatch == this.chars1.length() && prefixMatch >= colonPos;
        }
        return false;
    }

    private int scoreAuthorMatch(IntList list1, IntList list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return 75;
        }
        int p1 = 0;
        int p2 = 0;
        int size1 = list1.size();
        int size2 = list2.size();
        int nMatches = 0;
        int skipped1 = 0;
        int skipped2 = 0;
        int maxScore = 100;
        while (p1 < size1 && p2 < size2) {
            short subType2;
            int tag1 = list1.get(p1);
            int tag2 = list2.get(p2);
            short subType1 = this.data.tags.getSubType(tag1);
            if (subType1 == (subType2 = this.data.tags.getSubType(tag2))) {
                if (tag1 == tag2) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    continue;
                }
                if (this.matchPartialAuthor(tag1, tag2)) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    maxScore = 80;
                    continue;
                }
            }
            if (tag1 < tag2) {
                ++skipped1;
                ++p1;
                continue;
            }
            ++skipped2;
            ++p2;
        }
        if ((skipped1 += size1 - p1) == 0 && (skipped2 += size2 - p2) == 0) {
            assert (nMatches > 0);
            return maxScore;
        }
        if (nMatches > 0 && (skipped1 == 0 || skipped2 == 0)) {
            return 80;
        }
        return -100;
    }

    private boolean matchPartialAuthor(int tag1, int tag2) {
        this.data.tags.getChars(tag1, this.chars1);
        this.data.tags.getChars(tag2, this.chars2);
        if (this.chars2.length() > this.chars1.length()) {
            int tmp = tag1;
            tag1 = tag2;
            tag2 = tmp;
            TagChars cTmp = this.chars1;
            this.chars1 = this.chars2;
            this.chars2 = cTmp;
        }
        ++this.wordHashKey;
        int i = 0;
        while (i < this.chars1.length()) {
            int hashCode = 0;
            int nChars = 0;
            while (i < this.chars1.length()) {
                char c = this.chars1.charAt(i);
                if (charType[c] == 'p') {
                    ++i;
                    break;
                }
                hashCode = hashCode * 31 + c;
                ++nChars;
                ++i;
            }
            if (hashCode == 0 || nChars <= 3) continue;
            this.wordHash[(hashCode & Integer.MAX_VALUE) % FRBRGroupData.WORD_HASH_SIZE] = this.wordHashKey;
        }
        i = 0;
        int nWords2 = 0;
        int nMatch2 = 0;
        while (i < this.chars2.length()) {
            int hashCode = 0;
            int nChars = 0;
            while (i < this.chars2.length()) {
                char c = this.chars2.charAt(i);
                if (charType[c] == 'p') {
                    ++i;
                    break;
                }
                hashCode = hashCode * 31 + c;
                ++nChars;
                ++i;
            }
            if (hashCode == 0 || nChars <= 3) continue;
            ++nWords2;
            if (this.wordHash[(hashCode & Integer.MAX_VALUE) % WORD_HASH_SIZE] != this.wordHashKey) continue;
            ++nMatch2;
        }
        return nWords2 == nMatch2 && nWords2 >= 2;
    }

    private int scoreDateMatch(IntList list1, IntList list2) {
        int tag2;
        if (list1.isEmpty() || list2.isEmpty()) {
            return 0;
        }
        assert (list1.size() == 1);
        assert (list2.size() == 1);
        int tag1 = list1.get(0);
        if (tag1 == (tag2 = list2.get(0))) {
            return 50;
        }
        this.data.tags.getChars(tag1, this.chars1);
        this.data.tags.getChars(tag2, this.chars2);
        int year1 = this.parseYear(this.chars1);
        int year2 = this.parseYear(this.chars2);
        if (year1 < 0 || year2 < 0) {
            return 0;
        }
        if (year1 == year2) {
            return -20;
        }
        if (Math.abs(year1 - year2) <= 2) {
            return -40;
        }
        return -60;
    }

    private int parseYear(TagChars chars) {
        int num = 0;
        int i = 0;
        while (i < chars.length()) {
            char ch = chars.charAt(i);
            if (ch >= '0' && ch <= '9') {
                if ((num = num * 10 + (ch - 48)) > 1800 && num < 2100) {
                    return num;
                }
            } else {
                num = 0;
            }
            ++i;
        }
        return -99;
    }

    private int scoreIdMatch(IntList list1, IntList list2) {
        if (list1.isEmpty() && list2.isEmpty()) {
            return 0;
        }
        int p1 = 0;
        int p2 = 0;
        int size1 = list1.size();
        int size2 = list2.size();
        int nMatches = 0;
        int skipped1 = 0;
        int skipped2 = 0;
        int maxScore = 100;
        while (p1 < size1 && p2 < size2) {
            short subType2;
            int tag1 = list1.get(p1);
            int tag2 = list2.get(p2);
            short subType1 = this.data.tags.getSubType(tag1);
            if (subType1 == (subType2 = this.data.tags.getSubType(tag2))) {
                if (tag1 == tag2) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    continue;
                }
                if (this.matchPartialId(tag1, tag2)) {
                    ++nMatches;
                    ++p1;
                    ++p2;
                    maxScore = 80;
                    continue;
                }
            }
            if (tag1 < tag2) {
                ++skipped1;
                ++p1;
                continue;
            }
            ++skipped2;
            ++p2;
        }
        if ((skipped1 += size1 - p1) == 0 && (skipped2 += size2 - p2) == 0) {
            assert (nMatches > 0);
            return maxScore;
        }
        if (nMatches > 0 && (skipped1 == 0 || skipped2 == 0)) {
            return 80;
        }
        return 0;
    }

    private boolean matchPartialId(int tag1, int tag2) {
        this.data.tags.getChars(tag1, this.chars1);
        this.data.tags.getChars(tag2, this.chars2);
        int prefixMatch = this.chars1.prefixMatch(this.chars2);
        if (prefixMatch < 6) {
            return false;
        }
        int parenPos = this.chars1.indexOf('(');
        if (parenPos >= 6) {
            return prefixMatch == this.chars2.length() && prefixMatch >= parenPos;
        }
        parenPos = this.chars2.indexOf('(');
        if (parenPos >= 6) {
            return prefixMatch == this.chars1.length() && prefixMatch >= parenPos;
        }
        return false;
    }

    public String field() {
        return "dynamicFRBR";
    }

    public String name(int groupId) {
        return "group-" + groupId;
    }

    public int findGroup(String name) {
        if (!name.startsWith("group-")) {
            return -1;
        }
        return Integer.parseInt(name.substring("group-".length()));
    }

    public int child(int groupId) {
        return groupId == 0 && this.nGroups > 1 ? 1 : -1;
    }

    public int sibling(int groupId) {
        return groupId == 0 || groupId == this.nGroups - 1 ? -1 : groupId + 1;
    }

    public int parent(int groupId) {
        return groupId == 0 ? -1 : 0;
    }

    public int nChildren(int groupId) {
        return groupId == 0 ? this.nGroups - 1 : 0;
    }

    public int firstLink(int docId) {
        return this.docGroups.get(docId);
    }

    public int nextLink(int linkId) {
        return -1;
    }

    public int linkGroup(int linkId) {
        return linkId;
    }

    public int nGroups() {
        return this.nGroups;
    }

    public boolean isDynamic() {
        return true;
    }

    public int nDocHits(int groupId) {
        return this.groupDocCounts.get(groupId);
    }

    public float score(int groupId) {
        return this.groupScores.get(groupId);
    }

    public final int compare(int group1, int group2) {
        int doc2;
        if (group1 == group2) {
            return 0;
        }
        int doc1 = this.groupDocs.get(group1);
        int x = this.compareField(this.primarySort, doc1, doc2 = this.groupDocs.get(group2), this.reversePrimarySort);
        if (x != 0) {
            return x;
        }
        int t = 1;
        while (t <= 4) {
            if (t != this.primarySort && (x = this.compareField(t, doc1, doc2, false)) != 0) {
                return x;
            }
            ++t;
        }
        return 0;
    }

    private String docTitle(int doc) {
        int pos = this.data.docTags.firstPos(doc);
        while (pos >= 0) {
            int tag = this.data.docTags.getValue(pos);
            int type = this.data.tags.getType(tag);
            if (type == 1) {
                return this.data.tags.getString(tag);
            }
            pos = this.data.docTags.nextPos(pos);
        }
        return "";
    }

    private int compareField(int type, int doc1, int doc2, boolean reverse) {
        int tag1 = 0;
        int pos = this.data.docTags.firstPos(doc1);
        while (pos >= 0 && tag1 == 0) {
            int tag = this.data.docTags.getValue(pos);
            if (this.data.tags.getType(tag) == type) {
                tag1 = tag;
            }
            pos = this.data.docTags.nextPos(pos);
        }
        int tag2 = 0;
        int pos2 = this.data.docTags.firstPos(doc2);
        while (pos2 >= 0 && tag2 == 0) {
            int tag = this.data.docTags.getValue(pos2);
            if (this.data.tags.getType(tag) == type) {
                tag2 = tag;
            }
            pos2 = this.data.docTags.nextPos(pos2);
        }
        if (tag1 == 0) {
            int n = tag1 = reverse ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (tag2 == 0) {
            int n = tag2 = reverse ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (reverse) {
            return tag1 < tag2 ? 1 : (tag1 > tag2 ? -1 : 0);
        }
        return tag1 < tag2 ? -1 : (tag1 > tag2 ? 1 : 0);
    }
}

