/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.textEngine;

import java.io.File;
import org.cdlib.xtf.cache.GeneratingCache;
import org.cdlib.xtf.textIndexer.IndexerConfig;
import org.cdlib.xtf.textIndexer.XMLConfigParser;
import org.cdlib.xtf.util.Path;

public class ConfigCache
extends GeneratingCache {
    public ConfigCache() {
        super(50, 300);
    }

    public IndexerConfig find(File configFile, String indexName) throws Exception {
        ConfigCacheKey key = new ConfigCacheKey();
        key.configPath = Path.normalizeFileName(configFile.toString());
        key.indexName = indexName;
        return (IndexerConfig)super.find(key);
    }

    protected Object generate(Object key) throws Exception {
        ConfigCacheKey realKey = (ConfigCacheKey)key;
        IndexerConfig config = new IndexerConfig();
        config.xtfHomePath = System.getProperty("xtf.home");
        config.cfgFilePath = realKey.configPath;
        config.indexInfo.indexName = realKey.indexName;
        XMLConfigParser parser = new XMLConfigParser();
        parser.configure(config);
        return config;
    }

    private static class ConfigCacheKey {
        public String configPath;
        public String indexName;

        private ConfigCacheKey() {
        }

        public int hashCode() {
            return this.configPath.hashCode() ^ this.indexName.hashCode();
        }

        public boolean equals(ConfigCacheKey other) {
            return this.configPath.equals(other.configPath) && this.indexName.equals(other.indexName);
        }
    }
}

