/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.servletBase;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;

public class SessionURLRewriter
extends ProxyReceiver {
    private Pattern encodeURLPattern;
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private NamePool namePool;
    private String elementName;

    SessionURLRewriter(Receiver underlyingReceiver, Pattern encodeURLPattern, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.setUnderlyingReceiver(underlyingReceiver);
        this.encodeURLPattern = encodeURLPattern;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        this.elementName = this.getLocalName(nameCode);
        super.startElement(nameCode, typeCode, locationId, properties);
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String attrName = this.getLocalName(nameCode);
        if (!(this.elementName.equals("a") && attrName.equals("href") || this.elementName.equals("form") && attrName.equals("action") || this.elementName.equals("frame") && attrName.equals("src"))) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            return;
        }
        HttpSession session = this.httpRequest.getSession(false);
        if (session == null) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            return;
        }
        String strVal = value.toString();
        if (!this.encodeURLPattern.matcher(strVal).matches()) {
            super.attribute(nameCode, typeCode, value, locationId, properties);
            return;
        }
        String mapped = this.httpResponse.encodeURL(strVal);
        if (!mapped.equals(value)) {
            super.attribute(nameCode, typeCode, mapped, locationId, properties);
            return;
        }
        super.attribute(nameCode, typeCode, value, locationId, properties);
    }

    private String getLocalName(int nameCode) {
        if (this.namePool == null) {
            this.namePool = this.getNamePool();
        }
        return this.namePool.getLocalName(nameCode);
    }
}

