/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.sql;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.cdlib.xtf.saxonExt.sql.SQLInsert;
import org.cdlib.xtf.saxonExt.sql.SQLUpdate;

public class SQLColumn
extends XSLGeneralVariable {
    protected boolean evalSql = false;

    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableFingerprint();
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String selectAtt = null;
        String evalAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            String localName = atts.getLocalName(a);
            if (localName.equals("name")) {
                nameAtt = atts.getValue(a).trim();
            } else if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
            } else if (localName.equals("eval")) {
                evalAtt = atts.getValue(a);
            } else if (localName.equals("is-expression")) {
                evalAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(atts.getNameCode(a));
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else if (!this.getConfiguration().getNameChecker().isQName(nameAtt)) {
            this.compileError("Column name must be a valid QName");
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
        if (evalAtt != null) {
            this.evalSql = evalAtt.matches("^true$|^yes$|^1$");
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof SQLInsert) && !(this.getParent() instanceof SQLUpdate)) {
            this.compileError("parent node must be sql:insert");
        }
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, "sql:column/select", 0, null);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_ATOMIC, false, role, this.getStaticContext());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        ColumnInstruction inst = new ColumnInstruction(this.getColumnName(), this.evalSql);
        this.initializeInstruction(exec, inst);
        return inst;
    }

    public String getColumnName() {
        return Navigator.getAttributeValue(this, "", "name");
    }

    protected static class ColumnInstruction
    extends GeneralVariable {
        String name;
        boolean evalSql;

        public ColumnInstruction(String name, boolean evalSql) {
            this.name = name;
            this.evalSql = evalSql;
        }

        public String getColumnName() {
            return this.name;
        }

        public boolean evalSql() {
            return this.evalSql;
        }

        public InstructionInfo getInstructionInfo() {
            InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
            details.setConstructType(2005);
            return details;
        }

        public TailCall processLeavingTail(XPathContext context) {
            return null;
        }

        public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
            throw new UnsupportedOperationException();
        }
    }
}

