/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.saxonExt.redirect;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.cdlib.xtf.servletBase.TextServlet;

public class RedirectElement
extends ExtensionInstruction {
    Expression urlExp;
    Expression permanentExp;

    public void prepareAttributes() throws XPathException {
        String urlAtt = this.getAttributeList().getValue("", "url");
        if (urlAtt == null) {
            this.reportAbsence("url");
            return;
        }
        this.urlExp = this.makeAttributeValueTemplate(urlAtt);
        String permAtt = this.getAttributeList().getValue("", "permanent");
        if (permAtt != null) {
            this.permanentExp = this.makeAttributeValueTemplate(permAtt);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return new RedirectInstruction(this.urlExp);
    }

    private class RedirectInstruction
    extends SimpleExpression {
        Expression urlExp;

        public RedirectInstruction(Expression urlExp) {
            this.urlExp = urlExp;
        }

        public int getImplementationMethod() {
            return 1;
        }

        public String getExpressionType() {
            return "redirect:sendRedirect";
        }

        public Item evaluateItem(XPathContext context) throws XPathException {
            HttpServletResponse res = TextServlet.getCurResponse();
            String url = this.urlExp.evaluateAsString(context);
            String encodedUrl = TextServlet.getCurServlet().getConfig().sessionEncodeURLPattern == null ? url : res.encodeRedirectURL(url);
            String permanentStr = "no";
            if (RedirectElement.this.permanentExp != null) {
                permanentStr = RedirectElement.this.permanentExp.evaluateAsString(context);
            }
            try {
                if (permanentStr.matches("yes|Yes|true|True|1")) {
                    res.setHeader("Location", encodedUrl);
                    res.sendError(301);
                } else {
                    res.sendRedirect(encodedUrl);
                }
            }
            catch (IOException e) {
                throw new DynamicError(e);
            }
            return null;
        }
    }
}

