/*
 * Decompiled with CFR 0.152.
 */
package org.cdlib.xtf.lazyTree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.cdlib.xtf.lazyTree.LazyDocument;
import org.cdlib.xtf.lazyTree.NodeImpl;
import org.cdlib.xtf.util.DiskHashReader;
import org.cdlib.xtf.util.PackedByteBuf;

public class LazyHashMap
implements Map {
    private LazyDocument doc;
    private DiskHashReader reader;

    public LazyHashMap(LazyDocument doc, DiskHashReader reader) {
        this.doc = doc;
        this.reader = reader;
    }

    public Object get(Object key) {
        PackedByteBuf buf;
        try {
            buf = this.reader.find(key.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error encountered reading key from lazy tree file: ", e);
        }
        if (buf == null) {
            return null;
        }
        int nNodes = buf.readInt();
        ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>(nNodes);
        int curNum = 0;
        int i = 0;
        while (i < nNodes) {
            nodes.add(this.doc.getNode(curNum += buf.readInt()));
            ++i;
        }
        return nodes;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }
}

